/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.goaf.controller;

import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.goaf.entity.SensorMap;
import com.zhyc.xps.goaf.service.SensorMapService;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iot/sensormap"})
public class SensorMapController
extends BaseController {
    @Resource
    SensorMapService sensorMapService;

    @GetMapping(value={"/list"})
    public JsonResult getSensorMapByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<SensorMap> data = this.sensorMapService.getByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getSensorMapBypage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<SensorMap> data = this.sensorMapService.getByPage(map);
        return this.pageResult(data);
    }

    @PostMapping(value={"/add"})
    public JsonResult createSensorMap(@RequestBody SensorMap sensorMap) throws Exception {
        Long ocId = this.getCurOcId();
        sensorMap.setOcId(ocId);
        try {
            this.sensorMapService.create(sensorMap);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateSensorMap(@RequestBody SensorMap sensorMap) throws Exception {
        try {
            this.sensorMapService.update(sensorMap);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/delete/{sensorLocationId}"})
    public JsonResult deleteSensorMapById(@PathVariable Long sensorLocationId) throws Exception {
        Long ocId = this.getCurOcId();
        try {
            this.sensorMapService.delete(sensorLocationId);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

