/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.goaf.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import com.zhyc.xps.goaf.entity.GoafBaseInfo;
import com.zhyc.xps.goaf.mapper.GoafBaseInfoMapper;
import com.zhyc.xps.goaf.service.GoafBaseInfoService;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class GoafBaseInfoServiceImpl
extends BaseService
implements GoafBaseInfoService {
    @Resource
    GoafBaseInfoMapper goafBaseInfoMapper;

    @Override
    public List<GoafBaseInfo> getByList(Map<String, Object> map) {
        List<GoafBaseInfo> goafBaseInfoList = this.goafBaseInfoMapper.getByList(map);
        return goafBaseInfoList;
    }

    @Override
    public PageBean<GoafBaseInfo> getByPage(Map<String, Object> map) {
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List<GoafBaseInfo> goafBaseInfoList = this.goafBaseInfoMapper.getByPage(map);
        return new PageBean(goafBaseInfoList);
    }

    @Override
    public GoafBaseInfo getBygoafId(Long goafId) {
        GoafBaseInfo GoafBaseInfo2 = this.goafBaseInfoMapper.getBygoafId(goafId);
        return GoafBaseInfo2;
    }

    @Override
    public GoafBaseInfo getBygoafQr(String goafQr) {
        GoafBaseInfo GoafBaseInfo2 = this.goafBaseInfoMapper.getBygoafQr(goafQr);
        return GoafBaseInfo2;
    }

    @Override
    public void create(GoafBaseInfo goafBaseInfo) throws Exception {
        Long goafId = IdKit.getId();
        String goafQr = IdKit.getUUID32();
        goafBaseInfo.setGoafId(goafId);
        goafBaseInfo.setGoafQrCode(goafQr);
        this.goafBaseInfoMapper.create(goafBaseInfo);
    }

    @Override
    public void update(GoafBaseInfo goafBaseInfo) throws Exception {
        this.goafBaseInfoMapper.update(goafBaseInfo);
    }

    @Override
    public void delete(Long goafId) throws Exception {
        this.goafBaseInfoMapper.delete(goafId);
    }
}

