/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.goaf.service.impl;

import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import com.zhyc.xps.goaf.entity.SensorTypeCfg;
import com.zhyc.xps.goaf.mapper.SensorTypeMapper;
import com.zhyc.xps.goaf.service.SensorTypeService;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SensorTypeServiceImpl
extends BaseService
implements SensorTypeService {
    @Resource
    SensorTypeMapper sensorTypeMapper;

    @Override
    public List<SensorTypeCfg> getSensorTypeByList(Map<String, Object> map) {
        List<SensorTypeCfg> sensorTypeCfgList = this.sensorTypeMapper.getByList(map);
        return sensorTypeCfgList;
    }

    @Override
    public SensorTypeCfg getSensorTypeById(Long sensorTypeId) {
        SensorTypeCfg sensorTypeCfg = this.sensorTypeMapper.getBySensorType(sensorTypeId);
        return sensorTypeCfg;
    }

    @Override
    public void createSensorType(SensorTypeCfg sensorTypeCfg) throws Exception {
        Long sensorTypeId = IdKit.getId();
        sensorTypeCfg.setSensorTypeId(sensorTypeId);
        this.sensorTypeMapper.create(sensorTypeCfg);
    }

    @Override
    public void updateSensorType(SensorTypeCfg sensorTypeCfg) throws Exception {
        this.sensorTypeMapper.update(sensorTypeCfg);
    }

    @Override
    public void deleteSensorTypeByTypeId(Long typeId) throws Exception {
        this.sensorTypeMapper.delete(typeId);
    }
}

