/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.common.cache;

import com.zhyc.xps.common.dto.UserDto;
import com.zhyc.xps.common.utils.RedisUtils;
import jakarta.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class CacheManager {
    @Resource
    RedisUtils redisUtils;
    public String USER_PREFIX = "user_";
    public String PUSH_PREFIX = "push_";

    public void setUser(UserDto user) {
        String keyStr = this.USER_PREFIX + user.getUserId();
        this.redisUtils.set(keyStr, user);
    }

    public UserDto getUser(Long userId) {
        String keyStr = this.USER_PREFIX.concat(userId.toString());
        UserDto user = (UserDto)this.redisUtils.get(keyStr);
        return user;
    }

    public void clearUsers() {
        this.redisUtils.removePattern(this.USER_PREFIX.concat("*"));
    }

    public void removeUser(Long userId) {
        this.redisUtils.removePattern(this.USER_PREFIX.concat(userId.toString()));
    }

    public void setObject(String key, Object obj) {
        this.redisUtils.set(key, obj);
    }

    public Object getObject(String key) {
        return this.redisUtils.get(key);
    }

    public void setRegistrationID(Long userId, String registrationID) {
        String keyStr = this.PUSH_PREFIX + userId.toString();
        this.redisUtils.set(keyStr, registrationID);
    }

    public String getRegistrationID(Long userId) {
        String keyStr = this.PUSH_PREFIX + userId.toString();
        return this.redisUtils.getStringValue(keyStr);
    }
}

