/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.common.exception;

import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.exception.IException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public JsonResult errorHandler(Exception e) {
        JsonResult jsonResult = new JsonResult();
        if (e instanceof IException) {
            jsonResult.setCode(((IException)e).getCode());
            jsonResult.setMsg(e.getMessage());
        } else if (e instanceof HttpRequestMethodNotSupportedException) {
            jsonResult.setCode(404);
            jsonResult.setMsg("\u4e0d\u652f\u6301\u6b64\u8bf7\u6c42");
            log.error(e.getMessage(), (Throwable)e);
        } else if (e instanceof DataIntegrityViolationException) {
            jsonResult.setCode(500);
            jsonResult.setMsg("\u64cd\u4f5c\u5931\u8d25,\u7531\u4e8e\u6570\u636e\u8fc7\u957f");
            log.error(e.getMessage(), (Throwable)e);
        } else {
            jsonResult.setCode(500);
            jsonResult.setMsg(e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        return jsonResult;
    }
}

