/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.common.interceptor;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.zhyc.xps.common.config.JwtConfig;
import com.zhyc.xps.common.exception.IException;
import io.jsonwebtoken.Claims;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Enumeration;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class TokenInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TokenInterceptor.class);
    @Resource
    JwtConfig jwtConfig;

    public boolean preHandle(HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler) throws IException {
        if (HttpMethod.OPTIONS.toString().equals(request.getMethod())) {
            return true;
        }
        String uri = request.getRequestURI();
        if (uri.contains("/login")) {
            return true;
        }
        if (uri.contains("/upload/")) {
            return true;
        }
        if (uri.contains("/goaf/sensordata/uploadHikFile")) {
            return true;
        }
        if (uri.contains("/wx")) {
            return true;
        }
        if (uri.contains("/qr")) {
            return true;
        }
        if (uri.contains("/test")) {
            return true;
        }
        if (uri.contains("/report")) {
            return true;
        }
        if (uri.contains("/lic")) {
            return true;
        }
        String jwtHeader = this.jwtConfig.getHeader();
        String token = request.getHeader(jwtHeader);
        if (!StringUtils.hasText((String)token)) {
            token = request.getParameter(this.jwtConfig.getHeader());
        }
        if (!StringUtils.hasText((String)token)) {
            throw new IException(401, "\u6ca1\u6709TOKEN");
        }
        Claims claims = this.jwtConfig.getTokenClaim(token.replace("Bearer ", ""));
        if (ObjectUtils.isEmpty((Object)claims)) {
            throw new IException(401, "TOKEN\u9519\u8bef");
        }
        boolean bExpired = this.jwtConfig.isTokenExpired(claims.getExpiration());
        if (bExpired) {
            throw new IException(401, "TOKEN\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        JSONObject userObj = JSON.parseObject((String)claims.getSubject());
        request.setAttribute("ocId", (Object)userObj.getLong("ocId"));
        request.setAttribute("ocTypeId", (Object)userObj.getLong("ocTypeId"));
        request.setAttribute("userId", (Object)userObj.getLong("userId"));
        request.setAttribute("userName", (Object)userObj.getString("userName"));
        request.setAttribute("userRealName", (Object)userObj.getString("userRealName"));
        return true;
    }

    public JSONObject getParameterJson(HttpServletRequest request) {
        Enumeration ParamNames = request.getParameterNames();
        JSONObject postParameterJson = new JSONObject();
        while (ParamNames.hasMoreElements()) {
            String thisName = (String)ParamNames.nextElement();
            String thisValue = request.getParameter(thisName);
            postParameterJson.put((Object)thisName, (Object)thisValue);
        }
        return postParameterJson;
    }
}

