/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.common.listener;

import com.zhyc.xps.common.entity.Msg;
import com.zhyc.xps.common.entity.MsgCc;
import com.zhyc.xps.common.entity.MsgTo;
import com.zhyc.xps.common.event.MsgEvent;
import com.zhyc.xps.common.mapper.CommonMapper;
import com.zhyc.xps.common.mapper.MsgCcMapper;
import com.zhyc.xps.common.mapper.MsgMapper;
import com.zhyc.xps.common.mapper.MsgToMapper;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import com.zhyc.xps.common.vo.GroupMemberVo;
import com.zhyc.xps.common.vo.GroupVo;
import com.zhyc.xps.common.vo.MsgVo;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Async
@Component
public class MsgListener
implements ApplicationListener<MsgEvent> {
    private static final Logger log = LoggerFactory.getLogger(MsgListener.class);
    @Resource
    MsgMapper msgMapper;
    @Resource
    MsgToMapper msgToMapper;
    @Resource
    MsgCcMapper msgCcMapper;
    @Resource
    CommonMapper commonMapper;

    public void onApplicationEvent(MsgEvent event) {
        log.info("msg received");
        MsgVo msg = event.getMsg();
        Long ocId = msg.getOcId();
        Long msgFrId = msg.getMsgFrId();
        Long msgToGroupId = msg.getMsgToGroupId();
        String msgToGroupName = msg.getMsgToGroupName();
        Long msgToId = msg.getMsgToId();
        String msgToName = msg.getMsgToName();
        ArrayList<Long> arrMsgToId = msg.getArrMsgToId();
        ArrayList<String> arrMsgToName = msg.getArrMsgToName();
        Long msgCcId = msg.getMsgCcId();
        String msgCcName = msg.getMsgCcName();
        ArrayList<Long> arrMsgCcId = new ArrayList<Long>();
        ArrayList<String> arrMsgCcName = new ArrayList<String>();
        if (msgCcId != null) {
            arrMsgCcId.add(msgCcId);
            arrMsgCcName.add(msgCcName);
        } else if (msg.getArrMsgCcId() != null) {
            arrMsgCcId = msg.getArrMsgCcId();
            arrMsgCcName = msg.getArrMsgCcName();
        }
        Long msgCatId = msg.getMsgCatId();
        String msgContent = msg.getMsgContent();
        String msgDetail = msg.getMsgDetail();
        if (msgToId != null) {
            try {
                this.sendMsg(ocId, msgCatId, msgContent, msgDetail, msgFrId, msgToId, msgToName, arrMsgCcId, arrMsgCcName);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        if (arrMsgToId != null && !arrMsgToId.isEmpty()) {
            try {
                this.sendMsg(ocId, msgCatId, msgContent, msgDetail, msgFrId, arrMsgToId, arrMsgToName, arrMsgCcId, arrMsgCcName);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        if (msgToGroupId != null) {
            try {
                this.sendMsg(ocId, msgCatId, msgContent, msgDetail, msgFrId, msgToGroupId, arrMsgCcId, arrMsgCcName);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public void sendMsg(Long ocId, Long msgCatId, String msgContent, String msgDetail, Long msgFrId, Long msgToId, String msgToName, ArrayList<Long> arrMsgCcId, ArrayList<String> arrMsgCcName) throws Exception {
        Long msgId = IdKit.getId();
        String msgTo = msgToId.toString() + "/" + msgToName;
        String msgCc = "";
        if (arrMsgCcId != null) {
            msgCc = this.arrayToString(arrMsgCcId, arrMsgCcName);
        }
        this.createMsg(ocId, msgId, msgCatId, msgContent, msgDetail, msgFrId, "", msgTo, msgCc);
        this.createMsgTo(ocId, msgId, msgToId);
        for (Long msgCcId : arrMsgCcId) {
            this.createMsgCc(ocId, msgId, msgCcId);
        }
    }

    public void sendMsg(Long ocId, Long msgCatId, String msgContent, String msgDetail, Long msgFrId, ArrayList<Long> arrMsgToId, ArrayList<String> arrMsgToName, ArrayList<Long> arrMsgCcId, ArrayList<String> arrMsgCcName) throws Exception {
        Long msgId = IdKit.getId();
        String msgToGroup = "";
        String msgTo = "";
        if (arrMsgToId != null) {
            msgTo = this.arrayToString(arrMsgToId, arrMsgToName);
        }
        String msgCc = "";
        if (arrMsgCcId != null) {
            msgCc = this.arrayToString(arrMsgCcId, arrMsgCcName);
        }
        this.createMsg(ocId, msgId, msgCatId, msgContent, msgDetail, msgFrId, msgToGroup, msgTo, msgCc);
        for (Long msgToId : arrMsgToId) {
            this.createMsgTo(ocId, msgId, msgToId);
        }
        for (Long msgCcId : arrMsgCcId) {
            this.createMsgCc(ocId, msgId, msgCcId);
        }
    }

    public void sendMsg(Long ocId, Long msgCatId, String msgContent, String msgDetail, Long msgFrId, Long msgToGroupId, ArrayList<Long> arrMsgCcId, ArrayList<String> arrMsgCcName) throws Exception {
        Long msgId = IdKit.getId();
        GroupVo group = this.commonMapper.getGroupById(ocId, msgToGroupId);
        if (ObjectUtils.isEmpty((Object)group)) {
            throw new Exception("\u90e8\u95e8\u4e0d\u5b58\u5728");
        }
        Long nodeLeft = group.getNodeLeft();
        Long nodeRight = group.getNodeRight();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocId", ocId);
        map.put("nodeLeft", nodeLeft);
        map.put("nodeRight", nodeRight);
        List<GroupMemberVo> memberList = this.commonMapper.getGroupMemberByList(map);
        if (memberList.isEmpty()) {
            return;
        }
        String msgToGroup = msgToGroupId.toString() + "/" + group.getGroupName();
        String msgTo = "";
        String msgCc = "";
        if (arrMsgCcId != null) {
            msgCc = this.arrayToString(arrMsgCcId, arrMsgCcName);
        }
        this.createMsg(ocId, msgId, msgCatId, msgContent, msgDetail, msgFrId, msgToGroup, msgTo, msgCc);
        for (GroupMemberVo member : memberList) {
            this.createMsgTo(ocId, msgId, member.getAccountId());
        }
        for (Long msgCcId : arrMsgCcId) {
            this.createMsgCc(ocId, msgId, msgCcId);
        }
    }

    private void createMsg(Long ocId, Long msgId, Long msgCatId, String msgContent, String msgDetail, Long msgFrId, String msgToGroup, String msgTo, String msgCc) throws Exception {
        Msg msg = new Msg();
        msg.setOcId(ocId);
        msg.setMsgId(msgId);
        msg.setMsgCatId(msgCatId);
        msg.setMsgContent(msgContent);
        msg.setMsgDetail(msgDetail);
        msg.setMsgFrId(msgFrId);
        msg.setMsgToGroup(msgToGroup);
        msg.setMsgTo(msgTo);
        msg.setMsgCc(msgCc);
        msg.setMsgTime(LocalDateTime.now());
        msg.setCreatedAt(LocalDateTime.now());
        this.msgMapper.create(msg);
    }

    private void createMsgTo(Long ocId, Long msgId, Long msgToId) throws Exception {
        MsgTo mt = new MsgTo();
        mt.setOcId(ocId);
        mt.setMsgId(msgId);
        mt.setMsgToId(msgToId);
        mt.setCreatedAt(LocalDateTime.now());
        this.msgToMapper.create(mt);
    }

    private void createMsgCc(Long ocId, Long msgId, Long msgCcId) throws Exception {
        MsgCc mc = new MsgCc();
        mc.setOcId(ocId);
        mc.setMsgId(msgId);
        mc.setMsgCcId(msgCcId);
        mc.setCreatedAt(LocalDateTime.now());
        this.msgCcMapper.create(mc);
    }

    private String arrayToString(ArrayList<Long> idArray, ArrayList<String> nameArray) {
        if (idArray == null || idArray.size() <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < idArray.size(); ++i) {
            sb.append(idArray.get(i));
            sb.append("/");
            sb.append(nameArray.get(i));
            sb.append(",");
        }
        String sbz = sb.toString();
        return sbz.substring(0, sbz.length() - 1);
    }
}

