/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.common.spring.interceptor;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class LogInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LogInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse httpServletResponse, Object o) throws Exception {
        Enumeration HeaderNames;
        Enumeration ParameName;
        if (request.getRequestURI().indexOf(".") != -1) {
            return true;
        }
        StringBuilder sbBuilder = new StringBuilder("\n\r\n");
        sbBuilder.append(String.format("%-30s", "getPathInfo") + "\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014 " + request.getPathInfo()).append("\r\n");
        sbBuilder.append(String.format("%-30s", "getRequestURL") + "\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014 " + request.getRequestURL()).append("\r\n");
        sbBuilder.append(String.format("%-30s", "getRequestURI") + "\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014 " + request.getRequestURI()).append("\r\n");
        sbBuilder.append(String.format("%-30s", "getMethod") + "\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014 " + request.getMethod()).append("\r\n");
        sbBuilder.append(String.format("%-30s", "getProtocol") + "\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014 " + request.getProtocol()).append("\r\n");
        sbBuilder.append(String.format("%-30s", "getRemoteAddr") + "\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014 " + request.getRemoteAddr()).append("\r\n");
        Enumeration e = ParameName = request.getParameterNames();
        while (e.hasMoreElements()) {
            String thisName = (String)e.nextElement();
            String thisValue = request.getParameter(thisName);
            sbBuilder.append(String.format("%-30s", thisName) + "\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014 " + thisValue).append("\r\n");
        }
        Enumeration e2 = HeaderNames = request.getHeaderNames();
        while (e2.hasMoreElements()) {
            String thisName = (String)e2.nextElement();
            String thisValue = request.getHeader(thisName);
            sbBuilder.append(String.format("%-30s", thisName) + "\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014 " + thisValue).append("\r\n");
        }
        return true;
    }

    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {
    }
}

