/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.common.utils;

import com.zhyc.xps.common.utils.LogKit;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    public static boolean deleteDir(File dir) {
        String[] children;
        if (dir.isDirectory() && (children = dir.list()) != null) {
            for (String child : children) {
                boolean success = FileUtils.deleteDir(new File(dir, child));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static void copyfile(String oldPath, String newPath) throws IOException {
        File oldFile = new File(oldPath);
        if (oldFile.exists()) {
            try {
                int hasRead;
                FileInputStream fis = new FileInputStream(oldFile);
                FileOutputStream fos = new FileOutputStream(newPath);
                byte[] buffer = new byte[1024];
                while ((hasRead = fis.read(buffer)) != -1) {
                    fos.write(buffer, 0, hasRead);
                }
                fis.close();
            }
            catch (Exception e) {
                log.error("copyfile", (Throwable)e);
                throw new IOException(e.getMessage());
            }
        }
    }

    public static void copyDir(String oldPath, String newPath) throws IOException {
        if (!new File(newPath).exists()) {
            new File(newPath).mkdirs();
        }
        File f1 = new File(oldPath);
        File[] files = f1.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                File dirNew = new File(newPath + File.separator + files[i].getName());
                dirNew.mkdir();
                FileUtils.copyDir(oldPath + File.separator + files[i].getName(), newPath + File.separator + files[i].getName());
                continue;
            }
            String filePath = newPath + File.separator + files[i].getName();
            FileUtils.copyfile(files[i].getAbsolutePath(), filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File zipFiles(String target, String filePath, String fileName) {
        File srcFile = new File(target);
        ZipOutputStream out = null;
        File targetFile = new File(filePath, fileName.concat(".zip"));
        try {
            if (targetFile.exists()) {
                targetFile.delete();
            } else if (!targetFile.getParentFile().exists()) {
                targetFile.getParentFile().mkdirs();
            }
            out = new ZipOutputStream(new FileOutputStream(targetFile));
            if (srcFile.isFile()) {
                FileUtils.zipFile(srcFile, out, "");
            } else {
                File[] list = srcFile.listFiles();
                for (int i = 0; i < list.length; ++i) {
                    FileUtils.compress(list[i], out, "");
                }
            }
            System.out.println("\u538b\u7f29\u5b8c\u6bd5");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return targetFile;
    }

    private static void compress(File file, ZipOutputStream out, String basedir) {
        if (file.isDirectory()) {
            FileUtils.zipDirectory(file, out, basedir);
        } else {
            FileUtils.zipFile(file, out, basedir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFile(File srcfile, ZipOutputStream out, String basedir) {
        if (!srcfile.exists()) {
            return;
        }
        byte[] buf = new byte[1024];
        FileInputStream in = null;
        try {
            int len;
            in = new FileInputStream(srcfile);
            out.putNextEntry(new ZipEntry(basedir + srcfile.getName()));
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.closeEntry();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void zipDirectory(File dir, ZipOutputStream out, String basedir) {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            FileUtils.compress(files[i], out, basedir + dir.getName() + "/");
        }
    }

    public static void delFolder(String folderPath) {
        try {
            FileUtils.delAllFile(folderPath);
            String filePath = folderPath;
            File myFilePath = new File(filePath);
            myFilePath.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean delAllFile(String path) {
        boolean flag = false;
        File file = new File(path);
        if (!file.exists()) {
            return flag;
        }
        if (!file.isDirectory()) {
            return flag;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            temp = path.endsWith(File.separator) ? new File(path + tempList[i]) : new File(path + File.separator + tempList[i]);
            if (temp.isFile()) {
                temp.delete();
            }
            if (!temp.isDirectory()) continue;
            FileUtils.delAllFile(path + "/" + tempList[i]);
            FileUtils.delFolder(path + "/" + tempList[i]);
            flag = true;
        }
        return flag;
    }

    public static void getOutputStream(HttpServletResponse response, File file) throws IOException {
        if (file.exists()) {
            response.setContentLength((int)file.length());
            LogKit.me.log("\u4e0b\u8f7d\u6846\u9ed8\u8ba4\u663e\u793a\u7684\u6587\u4ef6\u540d", file.getName());
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(file.getName(), "UTF-8"));
            response.setContentType("application/octet-stream");
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            byte[] b = new byte[bufferedInputStream.available()];
            bufferedInputStream.read(b);
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write(b);
            fileInputStream.close();
            bufferedInputStream.close();
            outputStream.flush();
            outputStream.close();
        }
    }
}

