/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.common.utils.IdGenerator.sequence;

import com.zhyc.xps.common.utils.IdGenerator.sequence.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceUtils {
    private static final Logger log = LoggerFactory.getLogger(SequenceUtils.class);
    private static final long OFFSET = 1546300800L;
    private static long WORKER_ID;
    private static final long WORKER_ID_BITS = 5L;
    private static final long SEQUENCE_ID_BITS = 16L;
    private static final long WORKER_SHIFT_BITS = 16L;
    private static final long OFFSET_SHIFT_BITS = 21L;
    private static final long WORKER_ID_MAX = 15L;
    private static final long BACK_WORKER_ID_BEGIN = 16L;
    private static final long SEQUENCE_MAX = 65535L;
    private static final long BACK_TIME_MAX = 1L;
    private static long lastTimestamp;
    private static long sequence;
    private static long lastTimestampBak;
    private static long sequenceBak;

    public SequenceUtils(long workerId) {
        if (workerId < 0L || workerId > 15L) {
            throw new IllegalArgumentException(String.format("cmallshop.workerId\u8303\u56f4: 0 ~ %d \u76ee\u524d: %d", 15L, workerId));
        }
        WORKER_ID = workerId;
    }

    private SequenceUtils() {
    }

    public long nextId() {
        return this.nextId(SystemClock.now() / 1000L);
    }

    private synchronized long nextId(long timestamp) {
        if (timestamp < lastTimestamp) {
            log.warn("\u65f6\u949f\u56de\u62e8, \u542f\u7528\u5907\u4efd\u673a\u5668ID: now: [{}] last: [{}]", (Object)timestamp, (Object)lastTimestamp);
            return this.nextIdBackup(timestamp);
        }
        if (timestamp != lastTimestamp) {
            lastTimestamp = timestamp;
            sequence = 0L;
        }
        if (0L == (++sequence & 0xFFFFL)) {
            --sequence;
            return this.nextIdBackup(timestamp);
        }
        return timestamp - 1546300800L << 21 | WORKER_ID << 16 | sequence;
    }

    private long nextIdBackup(long timestamp) {
        if (timestamp < lastTimestampBak) {
            if (lastTimestampBak - SystemClock.now() / 1000L <= 1L) {
                timestamp = lastTimestampBak;
            } else {
                throw new RuntimeException(String.format("\u65f6\u949f\u56de\u62e8: now: [%d] last: [%d]", timestamp, lastTimestampBak));
            }
        }
        if (timestamp != lastTimestampBak) {
            lastTimestampBak = timestamp;
            sequenceBak = 0L;
        }
        if (0L == (++sequenceBak & 0xFFFFL)) {
            return this.nextIdBackup(timestamp + 1L);
        }
        return timestamp - 1546300800L << 21 | (WORKER_ID ^ 0x10L) << 16 | sequenceBak;
    }

    static {
        lastTimestamp = 0L;
        sequence = 0L;
        lastTimestampBak = 0L;
        sequenceBak = 0L;
    }
}

