/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.common.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseUtil {
    private static final Logger log = LoggerFactory.getLogger(LicenseUtil.class);

    private static String getMACAddress() throws Exception {
        InetAddress ia = InetAddress.getLocalHost();
        byte[] mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < mac.length; ++i) {
            String s;
            if (i != 0) {
                sb.append("-");
            }
            sb.append((String)((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? "0" + s : s));
        }
        return sb.toString().toUpperCase();
    }

    private static String getMACAddressPrefix() throws Exception {
        InetAddress ia = InetAddress.getLocalHost();
        byte[] mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < mac.length; ++i) {
            String s;
            if (i != 0) {
                sb.append("");
            }
            sb.append((String)((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? "0" + s : s));
        }
        return sb.toString().toUpperCase().substring(0, 4);
    }

    public static Boolean verifyLicense(String lic) throws Exception {
        String szMacPrefix = LicenseUtil.getMACAddressPrefix();
        String licMacSeg = lic.substring(lic.length() - 4);
        char[] arr = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        if (!szMacPrefix.equals(licMacSeg)) {
            return false;
        }
        String licStamp = lic.substring(2, lic.length() - 4);
        long milliSecondNow = LocalDateTime.now().toInstant(ZoneOffset.of("+8")).toEpochMilli();
        return milliSecondNow <= Long.parseLong(licStamp);
    }

    public static String generateLicense(int year, int month, int day) throws Exception {
        LocalDateTime lc = LocalDateTime.of(year, month, day, 23, 59, 59);
        long milliSecond = lc.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        String szStamp = Long.toString(milliSecond);
        String szMacPrefix = LicenseUtil.getMACAddressPrefix();
        char[] arr = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        StringBuilder sbLic = new StringBuilder();
        sbLic.append(arr[(int)(Math.random() * 36.0)]);
        sbLic.append(arr[(int)(Math.random() * 36.0)]);
        sbLic.append(szStamp);
        sbLic.append(szMacPrefix);
        return sbLic.toString();
    }
}

