/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.common.utils;

import com.zhyc.xps.common.entity.Msg;
import com.zhyc.xps.common.entity.MsgCc;
import com.zhyc.xps.common.entity.MsgTo;
import com.zhyc.xps.common.mapper.CommonMapper;
import com.zhyc.xps.common.mapper.MsgCcMapper;
import com.zhyc.xps.common.mapper.MsgMapper;
import com.zhyc.xps.common.mapper.MsgToMapper;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import com.zhyc.xps.common.vo.GroupMemberVo;
import com.zhyc.xps.common.vo.GroupVo;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class MsgUtil {
    private static final Logger log = LoggerFactory.getLogger(MsgUtil.class);
    @Resource
    MsgMapper msgMapper;
    @Resource
    MsgToMapper msgToMapper;
    @Resource
    MsgCcMapper msgCcMapper;
    @Resource
    CommonMapper commonMapper;

    public void sendMsg(Long ocId, Long msgCatId, String msgContent, String msgDetail, Long msgFrId, ArrayList<Long> arrMsgToId, ArrayList<Long> arrMsgCcId, Long userId) throws Exception {
        Long msgId = IdKit.getId();
        String msgTo = this.arrayToString(arrMsgToId);
        String msgCc = this.arrayToString(arrMsgCcId);
        this.createMsg(ocId, msgId, msgCatId, msgContent, msgDetail, msgFrId, "", msgTo, msgCc, userId);
        for (Long msgToId : arrMsgToId) {
            this.createMsgTo(ocId, msgId, msgToId, userId);
        }
        for (Long msgCcId : arrMsgCcId) {
            this.createMsgCc(ocId, msgId, msgCcId, userId);
        }
    }

    public void sendMsg(Long ocId, Long msgCatId, String msgContent, String msgDetail, Long msgFrId, Long msgToId, Long msgCcId, Long userId) throws Exception {
        Long msgId = IdKit.getId();
        this.createMsg(ocId, msgId, msgCatId, msgContent, msgDetail, msgFrId, "", msgToId.toString(), msgCcId.toString(), userId);
        this.createMsgTo(ocId, msgId, msgToId, userId);
        this.createMsgCc(ocId, msgId, msgCcId, userId);
    }

    public void sendMsg(Long ocId, Long msgCatId, String msgContent, String msgDetail, Long msgFrId, Long msgGroupToId, Long userId) throws Exception {
        Long msgId = IdKit.getId();
        GroupVo group = this.commonMapper.getGroupById(ocId, msgGroupToId);
        if (ObjectUtils.isEmpty((Object)group)) {
            throw new Exception("\u90e8\u95e8\u4e0d\u5b58\u5728");
        }
        Long nodeLeft = group.getNodeLeft();
        Long nodeRight = group.getNodeRight();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocId", ocId);
        map.put("nodeLeft", nodeLeft);
        map.put("nodeRight", nodeRight);
        List<GroupMemberVo> memberList = this.commonMapper.getGroupMemberByList(map);
        if (memberList.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (GroupMemberVo vo : memberList) {
            Long msgToId = vo.getAccountId();
            this.createMsgTo(ocId, msgId, msgToId, userId);
            sb.append(msgToId);
            sb.append(",");
        }
        String tMsgTo = sb.toString();
        String msgTo = tMsgTo.substring(0, tMsgTo.length() - 1);
        this.createMsg(ocId, msgId, msgCatId, msgContent, msgDetail, msgFrId, "", msgTo, "", userId);
    }

    private void createMsg(Long ocId, Long msgId, Long msgCatId, String msgContent, String msgDetail, Long msgFrId, String msgToGroup, String msgTo, String msgCc, Long userId) throws Exception {
        Msg msg = new Msg();
        msg.setOcId(ocId);
        msg.setMsgId(msgId);
        msg.setMsgCatId(msgCatId);
        msg.setMsgContent(msgContent);
        msg.setMsgDetail(msgDetail);
        msg.setMsgFrId(msgFrId);
        msg.setMsgToGroup("");
        msg.setMsgTo(msgTo);
        msg.setMsgCc(msgCc);
        msg.setMsgTime(LocalDateTime.now());
        msg.setCreatedAt(LocalDateTime.now());
        msg.setCreatedBy(userId);
        this.msgMapper.create(msg);
    }

    private void createMsgTo(Long ocId, Long msgId, Long msgToId, Long userId) throws Exception {
        MsgTo mt = new MsgTo();
        mt.setOcId(ocId);
        mt.setMsgId(msgId);
        mt.setMsgToId(msgToId);
        mt.setCreatedAt(LocalDateTime.now());
        mt.setCreatedBy(userId);
        this.msgToMapper.create(mt);
    }

    private void createMsgCc(Long ocId, Long msgId, Long msgCcId, Long userId) throws Exception {
        MsgCc mc = new MsgCc();
        mc.setOcId(ocId);
        mc.setMsgId(msgId);
        mc.setMsgCcId(msgCcId);
        mc.setCreatedAt(LocalDateTime.now());
        mc.setCreatedBy(userId);
        this.msgCcMapper.create(mc);
    }

    private String arrayToString(ArrayList<Long> idArray) {
        StringBuilder sb = new StringBuilder();
        for (Long id : idArray) {
            sb.append(id);
            sb.append(",");
        }
        String sbz = sb.toString();
        return sbz.substring(0, sbz.length() - 1);
    }
}

