/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.common.utils;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class PinYinUtil {
    public static String toPinyinInitial(String str) {
        Object convert = "";
        for (int j = 0; j < str.length(); ++j) {
            char word = str.charAt(j);
            String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)word);
            convert = pinyinArray != null ? (String)convert + pinyinArray[0].charAt(0) : (String)convert + word;
        }
        return convert;
    }

    public static String toPinYinLowerCase(String str) throws BadHanyuPinyinOutputFormatCombination {
        return PinYinUtil.toPinYin(str, "", Type.LOWERCASE);
    }

    public static String toPinYin(String str, String spera, Type type) throws BadHanyuPinyinOutputFormatCombination {
        HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
        format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        if (str == null || str.trim().length() == 0) {
            return "";
        }
        if (type == Type.UPPERCASE) {
            format.setCaseType(HanyuPinyinCaseType.UPPERCASE);
        } else {
            format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        }
        Object py = "";
        Object temp = "";
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c <= '\u0080') {
                py = (String)py + c;
                continue;
            }
            String[] t = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)format);
            if (t == null) {
                py = (String)py + c;
                continue;
            }
            temp = t[0];
            if (type == Type.FIRSTUPPER) {
                temp = t[0].toUpperCase().charAt(0) + ((String)temp).substring(1);
            }
            py = (String)py + (String)temp + (i == str.length() - 1 ? "" : spera);
        }
        return ((String)py).trim();
    }

    public static enum Type {
        UPPERCASE,
        LOWERCASE,
        FIRSTUPPER;

    }
}

