/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.common.utils.wx;

import cn.hutool.core.codec.Base64;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.zhyc.xps.common.setting.AppSetting;
import jakarta.annotation.Resource;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.stereotype.Component;

@Component
public class WXUtil {
    private final String wxLoginUrl = "https://api.weixin.qq.com/sns/jscode2session";
    private final String wxTokenUrl = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential";
    private final String wxPhoneUrl = "https://api.weixin.qq.com/wxa/business/getuserphonenumber?access_token=";
    @Resource
    AppSetting appSetting;

    public String wxLogin(String jsCode) {
        String appId = this.appSetting.getStringValueByKey("miniAppId");
        String appSecret = this.appSetting.getStringValueByKey("miniSecret");
        String sbUrl = "https://api.weixin.qq.com/sns/jscode2session?appid=" + appId + "&secret=" + appSecret + "&js_code=" + jsCode + "&grant_type=authorization_code";
        return HttpUtil.get((String)sbUrl, (int)3000);
    }

    public String wxGetPhone() {
        String appSecret;
        String appId = this.appSetting.getStringValueByKey("miniAppId");
        String sbUrl = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + appId + "&secret=" + (appSecret = this.appSetting.getStringValueByKey("miniSecret"));
        String result = HttpUtil.get((String)sbUrl, (int)3000);
        JSONObject jsonObject = JSON.parseObject((String)result);
        if (Integer.parseInt(jsonObject.get("errcode").toString()) == 0) {
            String accessToken = jsonObject.get("access_token").toString();
            sbUrl = "https://api.weixin.qq.com/wxa/business/getuserphonenumber?access_token=" + accessToken;
            return HttpUtil.post((String)sbUrl, (String)"", (int)3000);
        }
        return null;
    }

    public JSONObject getSessionByCode(String jscode) {
        String appId = this.appSetting.getStringValueByKey("miniAppId");
        String appSecret = this.appSetting.getStringValueByKey("miniSecret");
        String baseUrl = "https://api.weixin.qq.com/sns/jscode2session";
        HashMap<String, String> requestParam = new HashMap<String, String>();
        requestParam.put("appid", appId);
        requestParam.put("secret", appSecret);
        requestParam.put("js_code", jscode);
        requestParam.put("grant_type", "authorization_code");
        String result = HttpUtil.get((String)baseUrl, requestParam);
        return JSON.parseObject((String)result);
    }

    public JSONObject decryptUserInfo(String encryptData, String sessionKey, String iv) {
        byte[] dataByte = Base64.decode((CharSequence)encryptData);
        byte[] keyByte = Base64.decode((CharSequence)sessionKey);
        byte[] ivByte = Base64.decode((CharSequence)iv);
        try {
            int base = 16;
            if (keyByte.length % base != 0) {
                int groups = keyByte.length / base + (keyByte.length % base != 0 ? 1 : 0);
                byte[] temp = new byte[groups * base];
                Arrays.fill(temp, (byte)0);
                System.arraycopy(keyByte, 0, temp, 0, keyByte.length);
                keyByte = temp;
            }
            Security.addProvider((Provider)new BouncyCastleProvider());
            KeyGenerator.getInstance("AES").init(128);
            AlgorithmParameters iv1 = AlgorithmParameters.getInstance("AES");
            iv1.init(new IvParameterSpec(ivByte));
            SecretKeySpec secretKeySpec = new SecretKeySpec(keyByte, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
            cipher.init(2, (Key)secretKeySpec, iv1);
            byte[] decryptByte = cipher.doFinal(dataByte);
            if (null != decryptByte && decryptByte.length > 0) {
                String result = new String(decryptByte, "UTF-8");
                return JSON.parseObject((String)result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

