/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.common.ws;

import jakarta.websocket.OnClose;
import jakarta.websocket.OnError;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@ServerEndpoint(value="/websocket/link")
@Component
public class WebSocketServer {
    private static final Logger log = LoggerFactory.getLogger(WebSocketServer.class);
    private static final AtomicInteger onlineCount = new AtomicInteger(0);
    private static final Map<String, Session> clients = new ConcurrentHashMap<String, Session>();

    @OnOpen
    public void onOpen(Session session) {
        onlineCount.incrementAndGet();
        clients.put(session.getId(), session);
        log.info("\u6709\u65b0\u8fde\u63a5\u52a0\u5165\uff1a{}\uff0c\u5f53\u524d\u5728\u7ebf\u4eba\u6570\u4e3a\uff1a{}", (Object)session.getId(), (Object)onlineCount.get());
    }

    @OnClose
    public void onClose(Session session) {
        onlineCount.decrementAndGet();
        clients.remove(session.getId());
        log.info("\u6709\u4e00\u8fde\u63a5\u5173\u95ed\uff1a{}\uff0c\u5f53\u524d\u5728\u7ebf\u4eba\u6570\u4e3a\uff1a{}", (Object)session.getId(), (Object)onlineCount.get());
    }

    @OnError
    public void onError(Session session, Throwable error) {
        log.error("\u53d1\u751f\u9519\u8bef");
        error.printStackTrace();
    }

    public static void sendMessage(String message) {
        clients.forEach((k, v) -> {
            try {
                v.getBasicRemote().sendText(message);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private void sendMessage(String message, Session toSession) {
        try {
            log.info("\u670d\u52a1\u7aef\u7ed9\u5ba2\u6237\u7aef[{}]\u53d1\u9001\u6d88\u606f[{}]", (Object)toSession.getId(), (Object)message);
            toSession.getBasicRemote().sendText(message);
        }
        catch (Exception e) {
            log.error("\u670d\u52a1\u7aef\u53d1\u9001\u6d88\u606f\u7ed9\u5ba2\u6237\u7aef\u5931\u8d25\uff1a{}", (Throwable)e);
        }
    }
}

