/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.nhc.controller;

import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.lylc.dto.AssessDto;
import com.zhyc.xps.nhc.service.NhcAssessService;
import com.zhyc.xps.nhc.vo.NhcAssessVo;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/nhc/assess"})
public class NhcAssessController
extends BaseController {
    @Resource
    NhcAssessService assessService;

    @GetMapping(value={""})
    public JsonResult getAssessByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<AssessDto> data = this.assessService.getAssessByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/{targetOcId}/{year}/{month}/{storyId}/{targetId}/{itemId}/{pointId}"})
    public JsonResult getAssessById(@PathVariable Long targetOcId, @PathVariable int year, @PathVariable int month, @PathVariable Long storyId, @PathVariable Long targetId, @PathVariable Long itemId, @PathVariable Long pointId) {
        AssessDto data = this.assessService.getAssessById(targetOcId, year, month, storyId, targetId, itemId, pointId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PutMapping(value={"/update"})
    public JsonResult updateAssess(@RequestBody NhcAssessVo assess) throws CustomException {
        Long ocId = this.getCurOcId();
        Long groupId = this.getCurUserGroupId();
        Long positionId = this.getCurUserPositionId();
        Long userId = this.getCurUserId();
        try {
            assess.setOcId(ocId);
            assess.setGroupId(groupId);
            assess.setPositionId(positionId);
            assess.setUpdatedBy(userId);
            this.assessService.createOrUpdateAssess(assess);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }
}

