/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.nhc.controller;

import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.lylc.dto.AssessRecordDto;
import com.zhyc.xps.lylc.entity.AssessRecord;
import com.zhyc.xps.nhc.service.NhcAssessRecordService;
import com.zhyc.xps.nhc.vo.NhcAssessRecordVo;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/nhc/assess/record"})
public class NhcAssessRecordController
extends BaseController {
    @Resource
    NhcAssessRecordService assessRecordService;

    @GetMapping(value={""})
    public JsonResult getAssessRecordByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<AssessRecordDto> data = this.assessRecordService.getAssessRecordByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getAssessRecordByPage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<AssessRecordDto> data = this.assessRecordService.getAssessRecordByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={"/{recordId}"})
    public JsonResult getAssessRecordById(@PathVariable Long recordId) {
        Long ocId = this.getCurOcId();
        NhcAssessRecordVo data = this.assessRecordService.getAssessRecordById(ocId, recordId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", (Object)data);
    }

    @GetMapping(value={"/story/item/{storyId}/{itemId}"})
    public JsonResult getAssessRecordByStoryItemId(@PathVariable Long storyId, @PathVariable Long itemId) {
        Long ocId = this.getCurOcId();
        List<NhcAssessRecordVo> data = this.assessRecordService.getStoryItemAssessRecordById(ocId, storyId, itemId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PostMapping(value={"/add"})
    public JsonResult createAssessRecord(@RequestBody AssessRecord record) {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            record.setOcId(ocId);
            record.setCreatedBy(userId);
            this.assessRecordService.createAssessRecord(record);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @DeleteMapping(value={"/{recordId}"})
    public JsonResult deleteAssessRecordById(@PathVariable Long recordId) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("ocId", ocId);
            map.put("recordId", recordId);
            map.put("deletedBy", userId);
            this.assessRecordService.deleteAssessRecord(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

