/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.nhc.controller;

import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.lylc.dto.AssessRuleDto;
import com.zhyc.xps.lylc.entity.AssessRule;
import com.zhyc.xps.nhc.service.NhcAssessRuleService;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/nhc/assess/rule"})
public class NhcAssessRuleController
extends BaseController {
    @Resource
    NhcAssessRuleService ruleService;

    @GetMapping(value={""})
    public JsonResult getAssessRuleByList() {
        List<AssessRuleDto> data = this.ruleService.getAssessRuleByList();
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getAssessRuleByPage(@RequestParam Map<String, Object> map) {
        PageBean<AssessRuleDto> pageInfo = this.ruleService.getAssessRuleByPage(map);
        return this.pageResult(pageInfo);
    }

    @GetMapping(value={"/{storyId}"})
    public JsonResult getAssessRuleById(@PathVariable Long storyId) {
        AssessRuleDto alertType = this.ruleService.getAssessRuleById(storyId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", alertType);
    }

    @PostMapping(value={"/add"})
    public JsonResult createAssessRule(@RequestBody AssessRule story) {
        Long userId = this.getCurUserId();
        try {
            story.setCreatedBy(userId);
            this.ruleService.createAssessRule(story);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateAssessRule(@RequestBody AssessRule story) throws CustomException {
        Long userId = this.getCurUserId();
        try {
            story.setUpdatedBy(userId);
            this.ruleService.updateAssessRule(story);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{storyId}"})
    public JsonResult deleteAssessRuleById(@PathVariable Long storyId) throws CustomException {
        Long userId = this.getCurUserId();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("storyId", storyId);
            map.put("deletedBy", userId);
            this.ruleService.deleteAssessRule(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

