/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.nhc.controller;

import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.lylc.dto.AssessStoryDto;
import com.zhyc.xps.lylc.entity.AssessStory;
import com.zhyc.xps.nhc.service.NhcAssessStoryService;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/nhc/story"})
public class NhcAssessStoryController
extends BaseController {
    @Resource
    private NhcAssessStoryService storyService;

    @GetMapping(value={""})
    public JsonResult getAssessStoryByList(@RequestParam Map<String, Object> map) {
        List<AssessStoryDto> data = this.storyService.getAssessStoryByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getAssessStoryByPage(@RequestParam Map<String, Object> map) {
        PageBean<AssessStoryDto> data = this.storyService.getAssessStoryByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={"/{storyId}"})
    public JsonResult getAssessStoryById(@PathVariable Long storyId) {
        AssessStoryDto data = this.storyService.getAssessStoryById(storyId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PostMapping(value={"/add"})
    public JsonResult createAssessStory(@RequestBody AssessStory story) {
        Long userId = this.getCurUserId();
        try {
            story.setCreatedBy(userId);
            this.storyService.createAssessStory(story);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateAssessStory(@RequestBody AssessStory story) throws CustomException {
        Long userId = this.getCurUserId();
        try {
            story.setUpdatedBy(userId);
            this.storyService.updateAssessStory(story);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{storyId}"})
    public JsonResult deleteAssessStoryById(@PathVariable Long storyId) throws CustomException {
        Long userId = this.getCurUserId();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("storyId", storyId);
            map.put("deletedBy", userId);
            this.storyService.deleteAssessStory(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

