/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.nhc.controller;

import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.lylc.dto.AssessStoryTargetDto;
import com.zhyc.xps.lylc.entity.AssessStoryTarget;
import com.zhyc.xps.nhc.service.NhcAssessStoryTargetService;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/nhc/story/target"})
public class NhcAssessStoryTargetController
extends BaseController {
    @Resource
    NhcAssessStoryTargetService targetService;

    @GetMapping(value={""})
    public JsonResult getAssessStoryTargetByList(@RequestParam Map<String, Object> map) {
        List<AssessStoryTargetDto> data = this.targetService.getAssessStoryTargetByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getAssessStoryTargetByPage(@RequestParam Map<String, Object> map) {
        PageBean<AssessStoryTargetDto> pageInfo = this.targetService.getAssessStoryTargetByPage(map);
        return this.pageResult(pageInfo);
    }

    @GetMapping(value={"/{storyId}/{targetId}"})
    public JsonResult getAssessStoryTargetById(@PathVariable Long storyId, @PathVariable Long targetId) {
        AssessStoryTargetDto data = this.targetService.getAssessStoryTargetById(storyId, targetId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PostMapping(value={"/add"})
    public JsonResult createAssessStoryTarget(@RequestBody AssessStoryTarget target) {
        Long userId = this.getCurUserId();
        try {
            target.setCreatedBy(userId);
            this.targetService.createAssessStoryTarget(target);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f", null);
    }

    @PutMapping(value={"/update"})
    public JsonResult updateAssessStoryTarget(@RequestBody AssessStoryTarget target) throws CustomException {
        Long userId = this.getCurUserId();
        try {
            target.setUpdatedBy(userId);
            this.targetService.updateAssessStoryTarget(target);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{storyId}/{targetId}"})
    public JsonResult deleteAssessStoryById(@PathVariable Long storyId, @PathVariable Long targetId) throws CustomException {
        Long userId = this.getCurUserId();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("storyId", storyId);
            map.put("targetId", targetId);
            map.put("deletedBy", userId);
            this.targetService.deleteAssessStoryTarget(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

