/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.nhc.controller;

import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.lylc.dto.AssessStoryTargetItemDto;
import com.zhyc.xps.lylc.entity.AssessStoryTargetItem;
import com.zhyc.xps.nhc.service.NhcAssessStoryTargetItemService;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/nhc/story/target/item"})
public class NhcAssessStoryTargetItemController
extends BaseController {
    @Resource
    private NhcAssessStoryTargetItemService targetItemService;

    @GetMapping(value={""})
    public JsonResult getAssessStoryTargetItemByList(@RequestParam Map<String, Object> map) {
        List<AssessStoryTargetItemDto> data = this.targetItemService.getAssessStoryTargetItemByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getAssessStoryTargetItemByPage(@RequestParam Map<String, Object> map) {
        PageBean<AssessStoryTargetItemDto> pageInfo = this.targetItemService.getAssessStoryTargetItemByPage(map);
        return this.pageResult(pageInfo);
    }

    @GetMapping(value={"/{storyId}/{targetId}/{itemId}"})
    public JsonResult getAssessStoryTargetItemById(@PathVariable Long storyId, @PathVariable Long targetId, @PathVariable Long itemId) {
        AssessStoryTargetItemDto data = this.targetItemService.getAssessStoryTargetItemById(storyId, targetId, itemId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PostMapping(value={"/add"})
    public JsonResult createAssessStoryTargetItem(@RequestBody AssessStoryTargetItem storyItem) {
        Long userId = this.getCurUserId();
        try {
            storyItem.setCreatedBy(userId);
            this.targetItemService.createAssessStoryTargetItem(storyItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateAssessStoryTargetItem(@RequestBody AssessStoryTargetItem storyItem) throws CustomException {
        Long userId = this.getCurUserId();
        try {
            storyItem.setUpdatedBy(userId);
            this.targetItemService.updateAssessStoryTargetItem(storyItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{storyId}/{targetId}/{itemId}"})
    public JsonResult deleteAssessStoryTargetItemById(@PathVariable Long storyId, @PathVariable Long targetId, @PathVariable Long itemId) throws CustomException {
        Long userId = this.getCurUserId();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("storyId", storyId);
            map.put("targetId", targetId);
            map.put("itemId", itemId);
            map.put("deletedBy", userId);
            this.targetItemService.deleteAssessStoryTargetItem(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

