/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.nhc.controller;

import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.lylc.dto.AssessStoryTargetItemPointDto;
import com.zhyc.xps.lylc.entity.AssessStoryTargetItemPoint;
import com.zhyc.xps.nhc.service.NhcAssessStoryTargetItemPointService;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/nhc/story/target/item/point"})
public class NhcAssessStoryTargetItemPointController
extends BaseController {
    @Resource
    private NhcAssessStoryTargetItemPointService targetItemPointService;

    @GetMapping(value={""})
    public JsonResult getAssessStoryTargetItemPointByList(@RequestParam Map<String, Object> map) {
        List<AssessStoryTargetItemPointDto> data = this.targetItemPointService.getAssessStoryTargetItemPointByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getAssessStoryTargetItemPointByPage(@RequestParam Map<String, Object> map) {
        PageBean<AssessStoryTargetItemPointDto> data = this.targetItemPointService.getAssessStoryTargetItemPointByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={"/{storyId}/{targetId}/{itemId}/{pointId}"})
    public JsonResult getAssessStoryTargetItemPointById(@PathVariable Long storyId, @PathVariable Long targetId, @PathVariable Long itemId, @PathVariable Long pointId) {
        AssessStoryTargetItemPointDto data = this.targetItemPointService.getAssessStoryTargetItemPointById(storyId, targetId, itemId, pointId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PostMapping(value={"/add"})
    public JsonResult createAssessStoryTargetItemPoint(@RequestBody AssessStoryTargetItemPoint storyItemPoint) {
        Long userId = this.getCurUserId();
        try {
            storyItemPoint.setCreatedBy(userId);
            this.targetItemPointService.createAssessStoryTargetItemPoint(storyItemPoint);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateAssessStoryTargetItemPoint(@RequestBody AssessStoryTargetItemPoint storyItemPoint) throws CustomException {
        Long userId = this.getCurUserId();
        try {
            storyItemPoint.setUpdatedBy(userId);
            this.targetItemPointService.updateAssessStoryTargetItemPoint(storyItemPoint);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{storyId}/{targetId}/{itemId}/{pointId}"})
    public JsonResult deleteAssessStoryTargetItemPointById(@PathVariable Long storyId, @PathVariable Long targetId, @PathVariable Long itemId, @PathVariable Long pointId) throws CustomException {
        Long userId = this.getCurUserId();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("storyId", storyId);
            map.put("targetId", targetId);
            map.put("itemId", itemId);
            map.put("pointId", pointId);
            map.put("deletedBy", userId);
            this.targetItemPointService.deleteAssessStoryTargetItemPoint(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

