/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.nhc.controller;

import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.lylc.dto.HosDto;
import com.zhyc.xps.lylc.entity.Hos;
import com.zhyc.xps.nhc.service.NhcHosService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/nhc/hos"})
public class NhcHosController
extends BaseController {
    @Autowired
    private NhcHosService hosService;

    @GetMapping(value={""})
    public JsonResult geHosByList(@RequestParam Map<String, Object> map) {
        List<HosDto> data = this.hosService.getHosByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getHosByPage(@RequestParam Map<String, Object> map) {
        PageBean<HosDto> data = this.hosService.getHosByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={"/{ocId}"})
    public JsonResult getHosById(@PathVariable Long ocId) {
        HosDto data = this.hosService.getHosById(ocId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PostMapping(value={"/add"})
    public JsonResult createHos(@RequestBody Hos hos) throws CustomException {
        Long userId = this.getCurUserId();
        try {
            hos.setCreatedBy(userId);
            this.hosService.createHos(hos);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateHos(@RequestBody Hos hos) throws CustomException {
        Long curUserId = this.getCurUserId();
        try {
            hos.setUpdatedBy(curUserId);
            this.hosService.updateHos(hos);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{ocId}"})
    public JsonResult deleteHosById(@PathVariable Long ocId) throws CustomException {
        Long userId = this.getCurUserId();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("ocId", ocId);
            map.put("deletedBy", userId);
            this.hosService.deleteHos(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

