/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.nhc.controller;

import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.nhc.service.NhcProfileService;
import com.zhyc.xps.sys.constant.Glob;
import com.zhyc.xps.sys.dto.OrgDto;
import com.zhyc.xps.sys.entity.Org;
import jakarta.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/nhc/profile"})
public class NhcProfileController
extends BaseController {
    @Resource
    private NhcProfileService nhcProfileService;

    @GetMapping(value={""})
    public JsonResult getNhcProfile() {
        Long ocId = this.getCurOcId();
        OrgDto data = this.nhcProfileService.GetNhcInfoById(ocId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PutMapping(value={"/update"})
    public JsonResult UpdateNhcProfile(@RequestBody Org org) {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        org.setOcId(ocId);
        org.setOrgCatId(Glob.ORG_CAT_NHC);
        org.setUpdatedBy(userId);
        try {
            this.nhcProfileService.UpdateNhcInfo(org);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }
}

