/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.nhc.controller;

import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.nhc.service.NhcStatisService;
import com.zhyc.xps.nhc.vo.HosScoreVo;
import com.zhyc.xps.nhc.vo.HosStoryScoreVo;
import com.zhyc.xps.sys.service.ArtService;
import com.zhyc.xps.sys.service.EntService;
import com.zhyc.xps.sys.service.TaskService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/nhc"})
public class NhcStatisController
extends BaseController {
    @Resource
    private EntService entService;
    @Resource
    private NhcStatisService statisService;
    @Resource
    private TaskService taskService;
    @Resource
    private ArtService artService;

    @GetMapping(value={"/overview"})
    public JsonResult getOverview() {
        Long ocId = this.getCurOcId();
        HashMap<String, List<Serializable>> result = new HashMap<String, List<Serializable>>();
        HashMap<String, Long> cond = new HashMap<String, Long>();
        cond.put("ocId", ocId);
        List taskList = this.taskService.getTaskByList(cond);
        result.put("taskList", taskList);
        List artList = this.artService.getTopArtByList(cond);
        result.put("artList", artList);
        List<HosScoreVo> scoreVo = this.statisService.hosScoreByList();
        result.put("scoreRank", scoreVo);
        List<HosStoryScoreVo> paList = this.statisService.hosStoryScoreByList(1L);
        result.put("paRank", paList);
        List<HosStoryScoreVo> zlList = this.statisService.hosStoryScoreByList(2L);
        result.put("zlRank", zlList);
        List<HosStoryScoreVo> myList = this.statisService.hosStoryScoreByList(3L);
        result.put("myRank", myList);
        List<HosStoryScoreVo> zhList = this.statisService.hosStoryScoreByList(4L);
        result.put("zhRank", zhList);
        List<HosStoryScoreVo> jkList = this.statisService.hosStoryScoreByList(5L);
        result.put("jkRank", jkList);
        List<HosStoryScoreVo> jyList = this.statisService.hosStoryScoreByList(6L);
        result.put("jyRank", jyList);
        return this.resultOk("\u64cd\u4f5c\u6210\u529f", result);
    }

    @GetMapping(value={"/score"})
    public JsonResult hosScoreByList() {
        List<HosScoreVo> data = this.statisService.hosScoreByList();
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/score/{hosId}"})
    public JsonResult hosScoreById(@PathVariable Long hosId) {
        HosScoreVo data = this.statisService.hosScoreById(hosId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/story/score/{storyId}"})
    public JsonResult hosScoreByList(@PathVariable Long storyId) {
        List<HosStoryScoreVo> data = this.statisService.hosStoryScoreByList(storyId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/story/score/{hosId}/{storyId}"})
    public JsonResult hosStoryScoreById(@PathVariable Long hosId, @PathVariable Long storyId) {
        HosStoryScoreVo data = this.statisService.hosStoryScoreById(hosId, storyId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }
}

