/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.nhc.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import com.zhyc.xps.lylc.dto.AssessRecordAttachDto;
import com.zhyc.xps.lylc.dto.AssessRecordDto;
import com.zhyc.xps.lylc.entity.AssessRecord;
import com.zhyc.xps.lylc.mapper.AssessRecordAttachMapper;
import com.zhyc.xps.lylc.mapper.AssessRecordMapper;
import com.zhyc.xps.nhc.service.NhcAssessRecordService;
import com.zhyc.xps.nhc.vo.NhcAssessRecordVo;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class NhcAssessRecordServiceImpl
extends BaseService
implements NhcAssessRecordService {
    @Autowired
    private AssessRecordMapper recordMapper;
    @Autowired
    private AssessRecordAttachMapper attachMapper;

    @Override
    public PageBean<AssessRecordDto> getAssessRecordByPage(Map<String, Object> map) {
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List list = this.recordMapper.getByPage(map);
        PageBean pageData = new PageBean(list);
        return pageData;
    }

    @Override
    public List<AssessRecordDto> getAssessRecordByList(Map<String, Object> map) {
        return this.recordMapper.getByList(map);
    }

    @Override
    public NhcAssessRecordVo getAssessRecordById(Long ocId, Long recordId) {
        AssessRecordDto record = this.recordMapper.getById(ocId, recordId);
        NhcAssessRecordVo vo = new NhcAssessRecordVo();
        if (record == null) {
            return vo;
        }
        vo.setOcId(ocId);
        vo.setGroupId(record.getGroupId());
        vo.setGroupName(record.getGroupName());
        vo.setPositionId(record.getPositionId());
        vo.setPositionName(record.getPositionName());
        vo.setAccountId(record.getAccountId());
        vo.setAccountName(record.getAccountName());
        vo.setRecordId(record.getRecordId());
        vo.setStoryId(record.getStoryId());
        vo.setItemId(record.getItemId());
        vo.setTargetOcId(record.getTargetOcId());
        vo.setAssessTime(record.getAssessTime());
        vo.setEvent(record.getEvent());
        vo.setScore(record.getScore());
        vo.setRemark(record.getRemark());
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("ocId", ocId);
        map.put("recordId", recordId);
        List attchDtoList = this.attachMapper.getByList(map);
        vo.setAttachList(attchDtoList);
        return vo;
    }

    @Override
    public List<NhcAssessRecordVo> getStoryItemAssessRecordById(Long ocId, Long storyId, Long itemId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("ocId", ocId);
        map.put("storyId", storyId);
        map.put("itemId", itemId);
        ArrayList<NhcAssessRecordVo> volist = new ArrayList<NhcAssessRecordVo>();
        List recordList = this.recordMapper.getByList(map);
        List attchDtoList = this.attachMapper.getByList(map);
        if (recordList != null) {
            for (AssessRecordDto record : recordList) {
                NhcAssessRecordVo vo = new NhcAssessRecordVo();
                vo.setOcId(ocId);
                vo.setGroupId(record.getGroupId());
                vo.setGroupName(record.getGroupName());
                vo.setPositionId(record.getPositionId());
                vo.setPositionName(record.getPositionName());
                vo.setAccountId(record.getAccountId());
                vo.setAccountName(record.getAccountName());
                vo.setRecordId(record.getRecordId());
                vo.setStoryId(record.getStoryId());
                vo.setItemId(record.getItemId());
                vo.setTargetOcId(record.getTargetOcId());
                vo.setAssessTime(record.getAssessTime());
                vo.setEvent(record.getEvent());
                vo.setScore(record.getScore());
                vo.setRemark(record.getRemark());
                ArrayList<AssessRecordAttachDto> recordAttachList = new ArrayList<AssessRecordAttachDto>();
                for (AssessRecordAttachDto attachDto : attchDtoList) {
                    if (!attachDto.getRecordId().equals(record.getRecordId())) continue;
                    recordAttachList.add(attachDto);
                }
                vo.setAttachList(recordAttachList);
                volist.add(vo);
            }
        }
        return volist;
    }

    @Override
    public void createAssessRecord(AssessRecord record) throws Exception {
        record.setRecordId(Long.valueOf(IdKit.getId()));
        record.setCreatedAt(LocalDateTime.now());
        this.recordMapper.create(record);
    }

    @Override
    public void deleteAssessRecord(Map<String, Object> map) throws Exception {
        map.put("deletedFlag", 1);
        map.put("deletedAt", LocalDateTime.now());
        this.recordMapper.delete(map);
        this.attachMapper.delete(map);
    }
}

