/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.nhc.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import com.zhyc.xps.lylc.dto.AssessRuleDto;
import com.zhyc.xps.lylc.entity.AssessRule;
import com.zhyc.xps.lylc.mapper.AssessRuleMapper;
import com.zhyc.xps.nhc.service.NhcAssessRuleService;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class NhcAssessRuleServiceImpl
extends BaseService
implements NhcAssessRuleService {
    @Autowired
    private AssessRuleMapper assessRuleMapper;

    @Override
    public PageBean<AssessRuleDto> getAssessRuleByPage(Map<String, Object> map) {
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List list = this.assessRuleMapper.getByPage(map);
        PageBean pageData = new PageBean(list);
        return pageData;
    }

    @Override
    public List<AssessRuleDto> getAssessRuleByList() {
        return this.assessRuleMapper.getByList();
    }

    @Override
    public AssessRuleDto getAssessRuleById(Long storyId) {
        return this.assessRuleMapper.getById(storyId);
    }

    @Override
    public void createAssessRule(AssessRule assessRule) throws Exception {
        assessRule.setStoryId(Long.valueOf(IdKit.getId()));
        this.assessRuleMapper.create(assessRule);
    }

    @Override
    public void updateAssessRule(AssessRule assessRule) throws Exception {
        assessRule.setUpdatedAt(LocalDateTime.now());
        this.assessRuleMapper.update(assessRule);
    }

    @Override
    public void deleteAssessRule(Map<String, Object> map) throws Exception {
        map.put("deletedFlag", 1);
        map.put("deletedAt", LocalDateTime.now());
        this.assessRuleMapper.delete(map);
    }
}

