/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.nhc.service.impl;

import com.zhyc.xps.common.dto.AttachDto;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import com.zhyc.xps.lylc.dto.AssessDto;
import com.zhyc.xps.lylc.entity.AssessRecord;
import com.zhyc.xps.lylc.entity.AssessRecordAttach;
import com.zhyc.xps.lylc.mapper.AssessMapper;
import com.zhyc.xps.lylc.mapper.AssessRecordAttachMapper;
import com.zhyc.xps.lylc.mapper.AssessRecordMapper;
import com.zhyc.xps.lylc.mapper.AssessStoryTargetItemMapper;
import com.zhyc.xps.nhc.service.NhcAssessService;
import com.zhyc.xps.nhc.vo.NhcAssessVo;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class NhcAssessServiceImpl
extends BaseService
implements NhcAssessService {
    @Resource
    AssessMapper assessMapper;
    @Resource
    AssessRecordMapper recordMapper;
    @Resource
    AssessRecordAttachMapper attachMapper;
    @Resource
    AssessStoryTargetItemMapper storyItemMapper;

    @Override
    public List<AssessDto> getAssessByList(Map<String, Object> map) {
        return this.assessMapper.getByList(map);
    }

    @Override
    public AssessDto getAssessById(Long ocId, int year, int month, Long storyId, Long targetId, Long itemId, Long pointId) {
        return this.assessMapper.getById(ocId, year, month, storyId, targetId, itemId, pointId);
    }

    @Override
    public void createOrUpdateAssess(NhcAssessVo vo) throws Exception {
        Long ocId = vo.getOcId();
        Long targetOcId = vo.getTargetOcId();
        Long storyId = vo.getStoryId();
        Long targetId = vo.getTargetId();
        Long itemId = vo.getItemId();
        Long pointId = vo.getPointId();
        Double nhcScore = vo.getNhcScore();
        String remark = vo.getRemark();
        Long userId = vo.getUpdatedBy();
        LocalDateTime curTime = LocalDateTime.now();
        Long recordId = IdKit.getId();
        AssessRecord record = new AssessRecord();
        record.setOcId(ocId);
        record.setGroupId(vo.getGroupId());
        record.setPositionId(vo.getPositionId());
        record.setTargetOcId(vo.getTargetOcId());
        record.setAccountId(userId);
        record.setStoryId(storyId);
        record.setTargetId(targetId);
        record.setItemId(itemId);
        record.setPointId(pointId);
        record.setRecordId(recordId);
        record.setTargetOcId(ocId);
        record.setScore(nhcScore);
        record.setEvent("\u8bc4\u4ef7");
        record.setRemark(remark);
        record.setAssessTime(curTime);
        record.setCreatedAt(curTime);
        record.setCreatedBy(userId);
        this.recordMapper.create(record);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("ocId", ocId);
        map.put("recordId", recordId);
        this.attachMapper.delete(map);
        List<AttachDto> fileList = vo.getAttachList();
        if (!fileList.isEmpty()) {
            for (AttachDto attach : fileList) {
                this.attachFileAction(ocId, userId, storyId, itemId, recordId, attach);
            }
        }
    }

    private void attachFileAction(Long ocId, Long userId, Long storyId, Long itemId, Long recordId, AttachDto attachDto) throws Exception {
        Long fileId = attachDto.getFileId();
        AssessRecordAttach attach = new AssessRecordAttach();
        attach.setOcId(ocId);
        attach.setStoryId(storyId);
        attach.setItemId(itemId);
        attach.setRecordId(recordId);
        attach.setFileId(fileId);
        attach.setCreatedAt(LocalDateTime.now());
        attach.setCreatedBy(userId);
        this.attachMapper.create(attach);
    }
}

