/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.nhc.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import com.zhyc.xps.lylc.dto.HosDto;
import com.zhyc.xps.lylc.entity.Hos;
import com.zhyc.xps.lylc.mapper.HosMapper;
import com.zhyc.xps.nhc.service.NhcHosService;
import com.zhyc.xps.sys.constant.Glob;
import com.zhyc.xps.sys.entity.Group;
import com.zhyc.xps.sys.entity.GroupCat;
import com.zhyc.xps.sys.entity.Oc;
import com.zhyc.xps.sys.mapper.GroupCatMapper;
import com.zhyc.xps.sys.mapper.GroupMapper;
import com.zhyc.xps.sys.mapper.OcMapper;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class NhcHosServiceImpl
extends BaseService
implements NhcHosService {
    @Autowired
    private OcMapper ocMapper;
    @Autowired
    private GroupCatMapper groupCatMapper;
    @Autowired
    private GroupMapper groupMapper;
    @Autowired
    private HosMapper hosMapper;

    @Override
    public PageBean<HosDto> getHosByPage(Map<String, Object> map) {
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List list = this.hosMapper.getByPage(map);
        PageBean pageData = new PageBean(list);
        return pageData;
    }

    @Override
    public List<HosDto> getHosByList(Map<String, Object> map) {
        return this.hosMapper.getByList(map);
    }

    @Override
    public HosDto getHosById(Long ocId) {
        return this.hosMapper.getById(ocId);
    }

    @Override
    public void createHos(Hos h) throws Exception {
        Long ocId = IdKit.getId();
        Long userId = h.createdBy;
        Oc oc = new Oc();
        oc.setOcId(ocId);
        oc.setOcName(h.getHosName());
        oc.setOcTypeId(Glob.OCTYPE_ENT);
        oc.setRootId(ocId);
        oc.setParentId(Long.valueOf(0L));
        oc.setGroupId(ocId);
        oc.setNodeLeft(Long.valueOf(1L));
        oc.setNodeRight(Long.valueOf(2L));
        oc.setNodeLevel(Long.valueOf(1L));
        oc.setIsLeaf(Long.valueOf(1L));
        oc.setStatus(Long.valueOf(1L));
        oc.setCreatedBy(userId);
        oc.setCreatedAt(LocalDateTime.now());
        this.ocMapper.create(oc);
        GroupCat groupCat = new GroupCat();
        groupCat.setOcId(ocId);
        groupCat.setGroupCatId(ocId);
        groupCat.setGroupCatTitle("\u533b\u9662");
        groupCat.setIsFixed(Long.valueOf(1L));
        groupCat.setGroupCatDesc("\u63cf\u8ff0");
        groupCat.setCreatedAt(LocalDateTime.now());
        groupCat.setCreatedBy(userId);
        this.groupCatMapper.create(groupCat);
        Group group = new Group();
        group.setOcId(ocId);
        group.setGroupId(ocId);
        group.setGroupName(h.getHosName());
        group.setGroupCatId(ocId);
        group.setNodeLeft(Long.valueOf(1L));
        group.setNodeRight(Long.valueOf(2L));
        group.setParentId(Long.valueOf(0L));
        group.setRootId(ocId);
        group.setNodeLevel(Long.valueOf(1L));
        group.setIsLeaf(Long.valueOf(1L));
        group.setGroupPath("");
        group.setGroupCode("");
        group.setCreatedAt(LocalDateTime.now());
        group.setCreatedBy(userId);
        this.groupMapper.create(group);
        h.setOcId(ocId);
        h.setCreatedAt(LocalDateTime.now());
        this.hosMapper.create(h);
    }

    @Override
    public void updateHos(Hos e) throws Exception {
        Long ocId = e.getOcId();
        Long userId = e.updatedBy;
        Oc oc = new Oc();
        oc.setOcId(ocId);
        oc.setOcName(e.getHosName());
        oc.setUpdatedAt(LocalDateTime.now());
        oc.setUpdatedBy(userId);
        this.ocMapper.update(oc);
        Group group = new Group();
        group.setOcId(ocId);
        group.setGroupId(ocId);
        group.setGroupName(e.getHosName());
        group.setUpdatedAt(LocalDateTime.now());
        group.setUpdatedBy(userId);
        this.groupMapper.update(group);
        e.setUpdatedAt(LocalDateTime.now());
        this.hosMapper.update(e);
    }

    @Override
    public void deleteHos(Map<String, Object> map) throws Exception {
        map.put("deletedAt", LocalDateTime.now());
        map.put("deletedFlag", 1);
        this.hosMapper.delete(map);
    }
}

