/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.goaf.controller;

import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.common.utils.mqtt.MqttUtil;
import com.zhyc.xps.goaf.entity.GoafBaseInfo;
import com.zhyc.xps.goaf.service.GoafBaseInfoService;
import com.zhyc.xps.goaf.service.GoafMapFlayerService;
import com.zhyc.xps.sys.mapper.EntMapLayerMapper;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/goaf/goafbaseinfo"})
public class GoafBaseInfoController
extends BaseController {
    @Resource
    GoafBaseInfoService goafBaseInfoService;
    @Resource
    GoafMapFlayerService goafMapFlayerService;
    @Resource
    EntMapLayerMapper mapLayerMapper;
    @Resource
    MqttUtil mqttUtil;

    @GetMapping(value={"/list"})
    public JsonResult getGoafBaseInfoByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<GoafBaseInfo> data = this.goafBaseInfoService.getByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getGoafBaseInfoBypage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<GoafBaseInfo> data = this.goafBaseInfoService.getByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={"/{goafId}"})
    public JsonResult getGoafBaseInfoById(@PathVariable Long goafId) {
        GoafBaseInfo goafBaseInfo = this.goafBaseInfoService.getBygoafId(goafId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", goafBaseInfo);
    }

    @GetMapping(value={"/goafqr/{goafQr}"})
    public JsonResult getGoafBaseInfoById(@PathVariable String goafQr) {
        GoafBaseInfo goafBaseInfo = this.goafBaseInfoService.getBygoafQr(goafQr);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", goafBaseInfo);
    }

    @PostMapping(value={"/add"})
    public JsonResult createGoafBaseInfo(@RequestBody GoafBaseInfo goafBaseInfo) throws Exception {
        Long ocId = this.getCurOcId();
        goafBaseInfo.setOcId(ocId);
        try {
            this.goafBaseInfoService.create(goafBaseInfo);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    @DeleteMapping(value={"/delete/{goafId}"})
    public JsonResult deleteGoafBaseInfoById(@PathVariable Long goafId) throws Exception {
        try {
            this.goafBaseInfoService.delete(goafId);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

