/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.goaf.controller;

import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.common.utils.mqtt.MqttUtil;
import com.zhyc.xps.goaf.dto.GoafCameraAlarmDto;
import com.zhyc.xps.goaf.entity.GoafCameraAlarm;
import com.zhyc.xps.goaf.service.GoafCameraAlarmService;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/goaf/goafcameraalarm"})
public class GoafCameraAlarmController
extends BaseController {
    @Resource
    GoafCameraAlarmService goafCameraAlarmService;
    @Resource
    MqttUtil mqttUtil;

    @GetMapping(value={"/list"})
    public JsonResult getGoafCameraAlarmByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<GoafCameraAlarmDto> data = this.goafCameraAlarmService.getByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getGoafCameraAlarmBypage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<GoafCameraAlarmDto> data = this.goafCameraAlarmService.getByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={"/goafdevstatis"})
    public JsonResult goafdevstatis(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        int alarmStatisVo = this.goafCameraAlarmService.getStatisNum(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", alarmStatisVo);
    }

    @PostMapping(value={"/add"})
    public JsonResult createGoafCameraAlarm(@RequestBody GoafCameraAlarm goafCameraAlarm) throws Exception {
        Long ocId = this.getCurOcId();
        goafCameraAlarm.setOcId(ocId);
        try {
            this.goafCameraAlarmService.create(goafCameraAlarm);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateGoafCameraAlarm(@RequestBody GoafCameraAlarm goafCameraAlarm) throws Exception {
        Long userId = this.getCurUserId();
        String userName = this.getCurUserName();
        Long groupId = this.getCurOcGroupId();
        String groupName = this.getCurUserGroupName();
        LocalDateTime tNow = LocalDateTime.now();
        goafCameraAlarm.setGoafAlarmHandleAccountid(userId);
        goafCameraAlarm.setGoafAlarmHandleAccountname(userName);
        goafCameraAlarm.setGoafAlarmHandleGroupid(groupId);
        goafCameraAlarm.setGoafAlarmHandleGroupname(groupName);
        goafCameraAlarm.setGoafAlarmEndtime(tNow);
        try {
            this.goafCameraAlarmService.update(goafCameraAlarm);
            HashMap<String, Long> map = new HashMap<String, Long>();
            Long ocId = this.getCurOcId();
            map.put("ocId", ocId);
            String strtopic = "topic/goaf/waring/camera/" + ocId;
            this.mqttUtil.publish(strtopic, map);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/delete/{goafCameraAlarmId}"})
    public JsonResult deleteGoafCameraAlarmById(@PathVariable Long goafCameraAlarmId) throws Exception {
        try {
            this.goafCameraAlarmService.delete(goafCameraAlarmId);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

