/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.goaf.controller;

import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.goaf.entity.GoafCheckRecord;
import com.zhyc.xps.goaf.service.GoafCheckRecordService;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/goaf/goafcheckRecord"})
public class GoafCheckRecordController
extends BaseController {
    @Resource
    GoafCheckRecordService goafCheckRecordService;

    @GetMapping(value={"/list"})
    public JsonResult getGoafCheckRecordByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<GoafCheckRecord> data = this.goafCheckRecordService.getByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getGoafCheckRecordBypage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<GoafCheckRecord> data = this.goafCheckRecordService.getByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={"/{checkRecordId}"})
    public JsonResult getGoafCheckRecordById(@PathVariable Long checkRecordId) {
        GoafCheckRecord goafCheckRecord = this.goafCheckRecordService.getBycheckRecordId(checkRecordId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", goafCheckRecord);
    }

    @PostMapping(value={"/add"})
    public JsonResult createGoafCheckRecord(@RequestBody GoafCheckRecord goafCheckRecord) throws Exception {
        Long ocId = this.getCurOcId();
        goafCheckRecord.setOcId(ocId);
        try {
            this.goafCheckRecordService.create(goafCheckRecord);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }
}

