/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.goaf.controller;

import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.goaf.dto.GoafChecklistDto;
import com.zhyc.xps.goaf.entity.GoafChecklist;
import com.zhyc.xps.goaf.entity.GoafChecklistItem;
import com.zhyc.xps.goaf.service.GoafChecklistService;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/goaf/goafChecklist"})
public class GoafChecklistController
extends BaseController {
    @Resource
    GoafChecklistService goafChecklistService;

    @GetMapping(value={"/list"})
    public JsonResult getGoafChecklistByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<GoafChecklist> data = this.goafChecklistService.getChecklistByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getGoafChecklistBypage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<GoafChecklist> data = this.goafChecklistService.getChecklistByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={"/{goafchecklistId}"})
    public JsonResult getGoafChecklistById(@PathVariable Long goafchecklistId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        map.put("checklistId", goafchecklistId);
        List<GoafChecklist> data = this.goafChecklistService.getChecklistByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/checklistitem/{goafchecklistId}"})
    public JsonResult getGoafChecklistItemById(@PathVariable Long goafchecklistId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        map.put("checklistId", goafchecklistId);
        List<GoafChecklistItem> goafChecklistItemlist = this.goafChecklistService.getChecklistItemById(goafchecklistId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", goafChecklistItemlist);
    }

    @PostMapping(value={"/add"})
    public JsonResult createGoafChecklist(@RequestBody GoafChecklistDto goafChecklistDto) throws Exception {
        Long ocId = this.getCurOcId();
        goafChecklistDto.setOcId(ocId);
        try {
            this.goafChecklistService.create(goafChecklistDto);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateGoafChecklist(@RequestBody GoafChecklistDto goafChecklistDto) throws Exception {
        try {
            this.goafChecklistService.update(goafChecklistDto);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/deletecheckitemlist/{goafchecklistitemid}"})
    public JsonResult deleteGoafChecklistItemById(@PathVariable Long goafchecklistitemid) throws Exception {
        try {
            this.goafChecklistService.delete(goafchecklistitemid);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }

    @DeleteMapping(value={"/deletechecklist/{goafchecklistId}"})
    public JsonResult deleteGoafChecklistById(@PathVariable Long goafchecklistId) throws Exception {
        try {
            this.goafChecklistService.deleteAll(goafchecklistId);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

