/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.goaf.controller;

import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.common.utils.mqtt.MqttUtil;
import com.zhyc.xps.goaf.dto.GoafHdangerDto;
import com.zhyc.xps.goaf.service.GoafHdangerService;
import com.zhyc.xps.goaf.service.GoafMapFlayerService;
import com.zhyc.xps.sys.mapper.EntMapLayerMapper;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/goaf/goafhdanger"})
public class GoafHdangerController
extends BaseController {
    @Resource
    GoafHdangerService goafHdangerService;
    @Resource
    MqttUtil mqttUtil;
    @Resource
    GoafMapFlayerService goafMapFlayerService;
    @Resource
    EntMapLayerMapper mapLayerMapper;

    @GetMapping(value={"/list"})
    public JsonResult getGoafHdangerByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<GoafHdangerDto> data = this.goafHdangerService.getByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getGoafHdangerBypage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<GoafHdangerDto> data = this.goafHdangerService.getByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={"/{hdangerId}"})
    public JsonResult getGoafHdangerById(@PathVariable Long hdangerId) {
        GoafHdangerDto goafHdangerDto = this.goafHdangerService.getByhdangerId(hdangerId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", goafHdangerDto);
    }

    @PostMapping(value={"/add"})
    @PutMapping(value={"/update"})
    @DeleteMapping(value={"/delete/{hdangerId}"})
    public JsonResult deleteGoafHdangerById(@PathVariable Long hdangerId) throws Exception {
        try {
            this.goafHdangerService.delete(hdangerId);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("hdangerId", hdangerId);
        System.out.println("delete \u53d1\u5e03\u6d88\u606f\u5185\u5bb9hdangerId\uff1a" + hdangerId);
        Long ocId = this.getCurOcId();
        String strtopic = "topic/goaf/waring/person/" + ocId;
        this.mqttUtil.publish(strtopic, map);
        strtopic = "topic/goaf/waring/sensor/" + ocId;
        this.mqttUtil.publish(strtopic, map);
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

