/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.goaf.controller;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.goaf.entity.SensorTypeCfg;
import com.zhyc.xps.goaf.service.SensorTypeService;
import jakarta.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/goaf/sensortypecfg"})
public class SysConfController
extends BaseController {
    @Resource
    SensorTypeService sensorTypeService;

    @GetMapping(value={"/test"})
    public String gettest() {
        DateTime dateTime = DateUtil.offsetMonth((Date)DateUtil.date(), (int)-1);
        String strBegin = DateUtil.date().toString();
        return strBegin + " , " + dateTime.toString();
    }

    @GetMapping(value={"/list"})
    public JsonResult getSensorTypeByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<SensorTypeCfg> data = this.sensorTypeService.getSensorTypeByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/{sensorTypeId}"})
    public JsonResult getSensorTypeById(@PathVariable Long sensorTypeId) {
        SensorTypeCfg data = this.sensorTypeService.getSensorTypeById(sensorTypeId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PostMapping(value={"/add"})
    public JsonResult createSensorType(@RequestBody SensorTypeCfg sensorTypeCfg) throws Exception {
        Long ocId = this.getCurOcId();
        sensorTypeCfg.setOcId(ocId);
        try {
            this.sensorTypeService.createSensorType(sensorTypeCfg);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateSensorType(@RequestBody SensorTypeCfg SensorTypeCfg2) throws Exception {
        try {
            this.sensorTypeService.updateSensorType(SensorTypeCfg2);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fee\u6539\u6210\u529f");
    }

    @DeleteMapping(value={"/delete/{typeId}"})
    public JsonResult deleteSensorTypeByTypeId(@PathVariable Long typeId) throws Exception {
        try {
            this.sensorTypeService.deleteSensorTypeByTypeId(typeId);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

