/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.goaf.job;

import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.spring.ApplicationContextHelper;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import com.zhyc.xps.common.utils.ModbusCRC16;
import com.zhyc.xps.common.utils.mqtt.MqttUtil;
import com.zhyc.xps.goaf.constant.Glob;
import com.zhyc.xps.goaf.entity.GoafSensor;
import com.zhyc.xps.goaf.entity.GoafSensorAlarmReport;
import com.zhyc.xps.goaf.entity.GoafSensorData;
import com.zhyc.xps.goaf.entity.GoafSensoralarm;
import com.zhyc.xps.goaf.mapper.GoafSensorAlarmReportMapper;
import com.zhyc.xps.goaf.mapper.GoafSensorDataMapper;
import com.zhyc.xps.goaf.mapper.GoafSensorMapper;
import com.zhyc.xps.goaf.mapper.GoafSensoralarmMapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GoafCheckTaskJobService
extends BaseService {
    private static final Logger log = LoggerFactory.getLogger(GoafCheckTaskJobService.class);
    static int iconut = 0;
    public static Map<String, GoafSensorData> SensorDataMap = new HashMap<String, GoafSensorData>();
    public static Map<String, ChannelHandlerContext> channleMap = new HashMap<String, ChannelHandlerContext>();
    public static Map<String, Integer> iptosensorcodeMap = new HashMap<String, Integer>();
    public static Map<String, Long> stateMap = new HashMap<String, Long>();
    public static Map<String, Integer> readDataAddrMap = new HashMap<String, Integer>();

    public String byteToHexString(byte mByte) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] arr = new char[]{Digit[mByte >>> 4 & 0xF], Digit[mByte & 0xF]};
        String tmp = new String(arr);
        return tmp;
    }

    public int bytes2Short(byte[] bytes) {
        int result = 0;
        int len = bytes.length;
        for (int i = len - 1; i >= 0; --i) {
            result = (short)(result | (short)(i == 0 ? bytes[i] : bytes[i] & 0xFF) << (len - 1 - i << 3));
        }
        return result & 0xFFFF;
    }

    public int bytes2Shortwithsign(byte[] bytes) {
        int result = 0;
        int len = bytes.length;
        for (int i = len - 1; i >= 0; --i) {
            result = (short)(result | (short)(i == 0 ? bytes[i] : bytes[i] & 0xFF) << (len - 1 - i << 3));
        }
        int temp = result & 0xFFFF;
        if (temp > Short.MAX_VALUE) {
            temp -= 65536;
        }
        return temp;
    }

    public byte[] IntToBytes(int values) {
        byte[] b = new byte[4];
        b[3] = (byte)(values & 0xFF);
        b[2] = (byte)(values >> 8 & 0xFF);
        b[1] = (byte)(values >> 16 & 0xFF);
        b[0] = (byte)(values >> 24 & 0xFF);
        return b;
    }

    public int bytesToIntforSensorId(byte[] src) {
        int value = (src[0] & 0xFF) << 16 | (src[1] & 0xFF) << 8 | src[2] & 0xFF;
        return value;
    }

    public void sendmsgtosensor(ChannelHandlerContext ctx, byte[] cmdbytes) {
        int i;
        int ilenth = cmdbytes.length;
        byte[] byteswithcrc = new byte[ilenth + 2];
        String crc16 = ModbusCRC16.getStringCRC((byte[])cmdbytes);
        byte[] crc = ModbusCRC16.getByteCRC((byte[])cmdbytes);
        for (i = 0; i < cmdbytes.length; ++i) {
            byteswithcrc[i] = cmdbytes[i];
        }
        byteswithcrc[ilenth] = crc[0];
        byteswithcrc[ilenth + 1] = crc[1];
        for (i = 0; i < byteswithcrc.length; ++i) {
            String string = this.byteToHexString(byteswithcrc[i]);
        }
        ByteBuf resp = Unpooled.copiedBuffer((byte[])byteswithcrc);
        try {
            ctx.write((Object)resp);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
        ctx.flush();
    }

    public void AddSensorAlarmReport() throws Exception {
        GoafSensorAlarmReport goafSensorAlarmReport = new GoafSensorAlarmReport();
        GoafSensorAlarmReportMapper goafSensorAlarmReportMapper = (GoafSensorAlarmReportMapper)ApplicationContextHelper.getBean(GoafSensorAlarmReportMapper.class);
        LocalDateTime tNow = LocalDateTime.now();
        Long goafSensorAlarmReportId = IdKit.getId();
        goafSensorAlarmReport.setGoafSensorAlarmReportId(goafSensorAlarmReportId);
        goafSensorAlarmReport.setOcId(406283L);
        goafSensorAlarmReport.setGoafSensorAlarmReportTime(tNow);
        goafSensorAlarmReportMapper.create(goafSensorAlarmReport);
    }

    @Transactional
    public void execute(JobExecutionContext context) throws Exception {
        DateTimeFormatter formatter;
        JobDataMap dataMap = context.getTrigger().getJobDataMap();
        Long jobId = dataMap.getLongValue("jobId");
        Date nextFireTime = context.getNextFireTime();
        LocalTime now = LocalTime.now();
        String currentTime = now.format(formatter = DateTimeFormatter.ofPattern("HH:mm"));
        if (currentTime.equals("00:10")) {
            this.AddSensorAlarmReport();
        }
        byte[] bytes = new byte[]{1, 4, 0, 16, 0, 16};
        for (String key : channleMap.keySet()) {
            System.out.println("execute, key:" + key);
            ChannelHandlerContext ctx = channleMap.get(key);
            stateMap.put(key, Glob.SENSOR_REALTIME_DATA_1);
            this.sendmsgtosensor(ctx, bytes);
        }
        GoafSensorMapper goafSensorMapper = (GoafSensorMapper)ApplicationContextHelper.getBean(GoafSensorMapper.class);
        GoafSensorDataMapper goafSensorDataMapper = (GoafSensorDataMapper)ApplicationContextHelper.getBean(GoafSensorDataMapper.class);
        List<GoafSensorData> goafSensorDataList = goafSensorDataMapper.getLatestDatabyList();
        if (null == goafSensorDataList || 0 == goafSensorDataList.size()) {
            return;
        }
        LocalDateTime tNow = LocalDateTime.now();
        for (GoafSensorData goafSensorData : goafSensorDataList) {
            Long goafSensorId;
            GoafSensor goafSensor;
            LocalDateTime SensorDataLastTime = goafSensorData.getGoafDatareportTime();
            long minutesDifference = ChronoUnit.MINUTES.between(SensorDataLastTime, tNow);
            if (minutesDifference < Glob.GOAF_SEN_IS_ONLINE_TIMEINTERV || null == (goafSensor = goafSensorMapper.getByGoafSensorId(goafSensorId = goafSensorData.getGoafSensorId()))) continue;
            goafSensor.setGoafSensorStatus(1L);
            goafSensorMapper.update(goafSensor);
        }
    }

    public void revmsg(String clientIP, byte[] req) {
        Long readDataStage = stateMap.get(clientIP);
        GoafSensorData goafSensorData = SensorDataMap.get(clientIP);
        if (null == goafSensorData) {
            goafSensorData = new GoafSensorData();
            SensorDataMap.put(clientIP, goafSensorData);
        }
        byte[] temp = new byte[]{0, 0};
        if (Glob.SENSOR_STATE_GET_SENSORCODE == readDataStage) {
            if (4 != req[1]) {
                return;
            }
            byte[] bytesensorcode = new byte[]{0, 0, 0};
            bytesensorcode[0] = req[4];
            bytesensorcode[1] = req[5];
            bytesensorcode[2] = req[6];
            int sensorcode = this.bytesToIntforSensorId(bytesensorcode);
            iptosensorcodeMap.put(clientIP, sensorcode);
            System.out.println("clientIPport:" + clientIP);
            System.out.println("sensorcode:" + sensorcode);
        } else if (Glob.SENSOR_REALTIME_DATA_1 == readDataStage) {
            if (4 == req[1]) {
                byte len = req[2];
                if (Glob.SENSOR_REALTIME_DATA_1_LEN == (long)len) {
                    temp[0] = req[3];
                    temp[1] = req[4];
                    Long FrequencyX = this.bytes2Short(temp);
                    goafSensorData.setFrequencyX(FrequencyX);
                    temp[0] = req[5];
                    temp[1] = req[6];
                    Long FrequencyY = this.bytes2Short(temp);
                    goafSensorData.setFrequencyY(FrequencyY);
                    temp[0] = req[7];
                    temp[1] = req[8];
                    Long FrequencyZ = this.bytes2Short(temp);
                    goafSensorData.setFrequencyZ(FrequencyZ);
                    temp[0] = req[9];
                    temp[1] = req[10];
                    Long AccX = this.bytes2Short(temp);
                    goafSensorData.setAccX(AccX);
                    temp[0] = req[11];
                    temp[1] = req[12];
                    Long AccY = this.bytes2Short(temp);
                    goafSensorData.setAccY(AccY);
                    temp[0] = req[13];
                    temp[1] = req[14];
                    Long AccZ = this.bytes2Short(temp);
                    goafSensorData.setAccZ(AccZ);
                    temp[0] = req[15];
                    temp[1] = req[16];
                    Long VelX = this.bytes2Short(temp);
                    goafSensorData.setVelX(VelX);
                    temp[0] = req[17];
                    temp[1] = req[18];
                    Long VelY = this.bytes2Short(temp);
                    goafSensorData.setVelY(VelY);
                    temp[0] = req[19];
                    temp[1] = req[20];
                    Long VelZ = this.bytes2Short(temp);
                    goafSensorData.setVelZ(VelZ);
                    temp[0] = req[21];
                    temp[1] = req[22];
                    Long DisX = this.bytes2Short(temp);
                    goafSensorData.setDisX(DisX);
                    temp[0] = req[23];
                    temp[1] = req[24];
                    Long DisY = this.bytes2Short(temp);
                    goafSensorData.setDisY(DisY);
                    temp[0] = req[25];
                    temp[1] = req[26];
                    Long DisZ = this.bytes2Short(temp);
                    goafSensorData.setDisZ(DisZ);
                    temp[0] = req[27];
                    temp[1] = req[28];
                    Long Temperature = this.bytes2Shortwithsign(temp);
                    goafSensorData.setSensorTemperature(Temperature);
                    temp[0] = req[29];
                    temp[1] = req[30];
                    Long AngX = this.bytes2Shortwithsign(temp);
                    goafSensorData.setAngX(AngX);
                    temp[0] = req[31];
                    temp[1] = req[32];
                    Long AngY = this.bytes2Shortwithsign(temp);
                    goafSensorData.setAngY(AngY);
                    temp[0] = req[33];
                    temp[1] = req[34];
                    Long AngZ = this.bytes2Shortwithsign(temp);
                    goafSensorData.setAngZ(AngZ);
                }
            }
            byte[] bytes = new byte[]{1, 3, 0, 115, 0, 10};
            ChannelHandlerContext ctx = channleMap.get(clientIP);
            stateMap.put(clientIP, Glob.SENSOR_REALTIME_DATA_2);
            this.sendmsgtosensor(ctx, bytes);
        } else if (Glob.SENSOR_REALTIME_DATA_2 == readDataStage) {
            if (3 == req[1]) {
                byte len = req[2];
                if (Glob.SENSOR_REALTIME_DATA_2_LEN == (long)len) {
                    temp[0] = req[3];
                    temp[1] = req[4];
                    Long FAlarmAccX = this.bytes2Short(temp);
                    goafSensorData.setFAlarmAccX(FAlarmAccX);
                    temp[0] = req[5];
                    temp[1] = req[6];
                    Long FAlarmAccY = this.bytes2Short(temp);
                    goafSensorData.setFAlarmAccY(FAlarmAccY);
                    temp[0] = req[7];
                    temp[1] = req[8];
                    Long FAlarmAccZ = this.bytes2Short(temp);
                    goafSensorData.setFAlarmAccZ(FAlarmAccZ);
                    temp[0] = req[9];
                    temp[1] = req[10];
                    Long FAlarmVelX = this.bytes2Short(temp);
                    goafSensorData.setFAlarmVelX(FAlarmVelX);
                    temp[0] = req[11];
                    temp[1] = req[12];
                    Long FAlarmVelY = this.bytes2Short(temp);
                    goafSensorData.setFAlarmVelY(FAlarmVelY);
                    temp[0] = req[13];
                    temp[1] = req[14];
                    Long FAlarmVelZ = this.bytes2Short(temp);
                    goafSensorData.setFAlarmVelZ(FAlarmVelZ);
                    temp[0] = req[15];
                    temp[1] = req[16];
                    Long FAlarmDisX = this.bytes2Short(temp);
                    goafSensorData.setFAlarmDisX(FAlarmDisX);
                    temp[0] = req[17];
                    temp[1] = req[18];
                    Long FAlarmDisY = this.bytes2Short(temp);
                    goafSensorData.setFAlarmDisY(FAlarmDisY);
                    temp[0] = req[19];
                    temp[1] = req[20];
                    Long FAlarmDisZ = this.bytes2Short(temp);
                    goafSensorData.setFAlarmDisZ(FAlarmDisZ);
                    temp[0] = req[21];
                    temp[1] = req[22];
                    Long FAlarmTemperature = this.bytes2Shortwithsign(temp);
                    goafSensorData.setFAlarmTemperature(FAlarmTemperature);
                }
                byte[] bytes = new byte[]{1, 3, 39, 16, 0, 1};
                stateMap.put(clientIP, Glob.SENSOR_REALTIME_DATA_3_1);
                ChannelHandlerContext ctx = channleMap.get(clientIP);
                this.sendmsgtosensor(ctx, bytes);
            }
        } else if (Glob.SENSOR_REALTIME_DATA_3_1 == readDataStage) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            temp[0] = req[3];
            temp[1] = req[4];
            Long Flag = this.bytes2Short(temp);
            if (0L == Flag) {
                byte[] bytes = new byte[]{1, 6, 39, 16, 0, 1};
                stateMap.put(clientIP, Glob.SENSOR_REALTIME_DATA_3_2);
                ChannelHandlerContext ctx = channleMap.get(clientIP);
                this.sendmsgtosensor(ctx, bytes);
            } else if (1L == Flag) {
                byte[] bytes = new byte[]{1, 3, 39, 16, 0, 1};
                stateMap.put(clientIP, Glob.SENSOR_REALTIME_DATA_3_1);
                ChannelHandlerContext ctx = channleMap.get(clientIP);
                this.sendmsgtosensor(ctx, bytes);
            } else if (2L == Flag) {
                byte[] bytes = new byte[]{1, 4, 39, 17, 0, 100};
                stateMap.put(clientIP, Glob.SENSOR_REALTIME_DATA_3_3_X);
                readDataAddrMap.put(clientIP, 10001);
                ChannelHandlerContext ctx = channleMap.get(clientIP);
                this.sendmsgtosensor(ctx, bytes);
            } else {
                byte[] bytes = new byte[]{1, 3, 39, 16, 0, 1};
                stateMap.put(clientIP, Glob.SENSOR_REALTIME_DATA_3_1);
                ChannelHandlerContext ctx = channleMap.get(clientIP);
                this.sendmsgtosensor(ctx, bytes);
            }
        } else if (Glob.SENSOR_REALTIME_DATA_3_2 == readDataStage) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            byte[] bytes = new byte[]{1, 3, 39, 16, 0, 1};
            stateMap.put(clientIP, Glob.SENSOR_REALTIME_DATA_3_1);
            ChannelHandlerContext ctx = channleMap.get(clientIP);
            this.sendmsgtosensor(ctx, bytes);
        } else if (Glob.SENSOR_REALTIME_DATA_3_3_X == readDataStage) {
            if (4 != req[1]) {
                return;
            }
            ++iconut;
            String TdWaveValueX = goafSensorData.getTdWaveValueX();
            if (null == TdWaveValueX) {
                TdWaveValueX = "";
            }
            int len = Byte.toUnsignedInt(req[2]);
            for (int i = 0; i < len; i += 2) {
                temp[0] = req[3 + i];
                temp[1] = req[3 + i + 1];
                Long WaveValue = this.bytes2Shortwithsign(temp);
                TdWaveValueX = TdWaveValueX + WaveValue;
                TdWaveValueX = TdWaveValueX + ",";
            }
            goafSensorData.setTdWaveValueX(TdWaveValueX);
            Integer iAddr = readDataAddrMap.get(clientIP);
            Integer iNextAdd = iAddr + 100;
            if (iNextAdd >= 10200) {
                // empty if block
            }
            if (iNextAdd >= 11600) {
                byte[] bytes = new byte[]{1, 4, 78, 33, 0, 100};
                stateMap.put(clientIP, Glob.SENSOR_REALTIME_DATA_3_3_Y);
                readDataAddrMap.put(clientIP, 20001);
                ChannelHandlerContext ctx = channleMap.get(clientIP);
                this.sendmsgtosensor(ctx, bytes);
            } else {
                byte[] bytes = new byte[]{1, 4, 39, 17, 0, 100};
                byte[] nextbyte = this.IntToBytes(iNextAdd);
                bytes[2] = nextbyte[2];
                bytes[3] = nextbyte[3];
                stateMap.put(clientIP, Glob.SENSOR_REALTIME_DATA_3_3_X);
                readDataAddrMap.put(clientIP, iNextAdd);
                ChannelHandlerContext ctx = channleMap.get(clientIP);
                this.sendmsgtosensor(ctx, bytes);
            }
        } else if (Glob.SENSOR_REALTIME_DATA_3_3_Y == readDataStage) {
            if (4 != req[1]) {
                return;
            }
            String TdWaveValueY = goafSensorData.getTdWaveValueY();
            if (null == TdWaveValueY) {
                TdWaveValueY = "";
            }
            int len = Byte.toUnsignedInt(req[2]);
            for (int i = 0; i < len; i += 2) {
                temp[0] = req[3 + i];
                temp[1] = req[3 + i + 1];
                Long WaveValue = this.bytes2Shortwithsign(temp);
                TdWaveValueY = TdWaveValueY + WaveValue;
                TdWaveValueY = TdWaveValueY + ",";
            }
            goafSensorData.setTdWaveValueY(TdWaveValueY);
            Integer iAddr = readDataAddrMap.get(clientIP);
            Integer iNextAdd = iAddr + 100;
            if (iNextAdd >= 21600) {
                byte[] bytes = new byte[]{1, 4, 117, 49, 0, 100};
                stateMap.put(clientIP, Glob.SENSOR_REALTIME_DATA_3_3_Z);
                readDataAddrMap.put(clientIP, 30001);
                ChannelHandlerContext ctx = channleMap.get(clientIP);
                this.sendmsgtosensor(ctx, bytes);
            } else {
                byte[] bytes = new byte[]{1, 4, 39, 17, 0, 100};
                byte[] nextbyte = this.IntToBytes(iNextAdd);
                bytes[2] = nextbyte[2];
                bytes[3] = nextbyte[3];
                stateMap.put(clientIP, Glob.SENSOR_REALTIME_DATA_3_3_Y);
                readDataAddrMap.put(clientIP, iNextAdd);
                ChannelHandlerContext ctx = channleMap.get(clientIP);
                this.sendmsgtosensor(ctx, bytes);
            }
        } else if (Glob.SENSOR_REALTIME_DATA_3_3_Z == readDataStage) {
            if (4 != req[1]) {
                return;
            }
            String TdWaveValueZ = goafSensorData.getTdWaveValueZ();
            if (null == TdWaveValueZ) {
                TdWaveValueZ = "";
            }
            int len = Byte.toUnsignedInt(req[2]);
            for (int i = 0; i < len; i += 2) {
                temp[0] = req[3 + i];
                temp[1] = req[3 + i + 1];
                Long WaveValue = this.bytes2Shortwithsign(temp);
                TdWaveValueZ = TdWaveValueZ + WaveValue;
                TdWaveValueZ = TdWaveValueZ + ",";
            }
            goafSensorData.setTdWaveValueZ(TdWaveValueZ);
            Integer iAddr = readDataAddrMap.get(clientIP);
            Integer iNextAdd = iAddr + 100;
            if (iNextAdd >= 31600) {
                byte[] bytes = new byte[]{1, 6, 39, 16, 0, 0};
                stateMap.put(clientIP, Glob.SENSOR_REALTIME_DATA_0);
                ChannelHandlerContext ctx = channleMap.get(clientIP);
                this.sendmsgtosensor(ctx, bytes);
                try {
                    this.SaveSensorData(goafSensorData, clientIP);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new CustomException();
                }
                goafSensorData.setTdWaveValueX("");
                goafSensorData.setTdWaveValueY("");
                goafSensorData.setTdWaveValueZ("");
            } else {
                byte[] bytes = new byte[]{1, 4, 39, 17, 0, 100};
                byte[] nextbyte = this.IntToBytes(iNextAdd);
                bytes[2] = nextbyte[2];
                bytes[3] = nextbyte[3];
                stateMap.put(clientIP, Glob.SENSOR_REALTIME_DATA_3_3_Z);
                readDataAddrMap.put(clientIP, iNextAdd);
                ChannelHandlerContext ctx = channleMap.get(clientIP);
                this.sendmsgtosensor(ctx, bytes);
            }
        }
    }

    public void SaveSensorAlarm(GoafSensorData goafSensorData) {
        Long goafSensorAlarmLevel = -1L;
        String goafSensorAlarmType = "";
        GoafSensoralarm goafSensoralarm = new GoafSensoralarm();
        GoafSensorMapper goafSensorMapper = (GoafSensorMapper)ApplicationContextHelper.getBean(GoafSensorMapper.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        String goafSensorName = goafSensorData.getGoafSensorName();
        Long ocId = goafSensorData.getOcId();
        map.put("goafSensorName", goafSensorName);
        map.put("ocId", ocId);
        List<GoafSensor> goafSensorList = goafSensorMapper.getByList(map);
        if (goafSensorList.size() <= 0) {
            return;
        }
        GoafSensor goafSensor = goafSensorList.get(0);
        Long thvAccX = goafSensor.getThvAccX();
        Long thvAccY = goafSensor.getThvAccY();
        Long thvAccZ = goafSensor.getThvAccZ();
        Long thvVelX = goafSensor.getThvVelX();
        Long thvVelY = goafSensor.getThvVelY();
        Long thvVelZ = goafSensor.getThvVelZ();
        Long thvDisX = goafSensor.getThvDisX();
        Long thvDisY = goafSensor.getThvDisY();
        Long thvDisZ = goafSensor.getThvDisZ();
        Long thvTemperature = goafSensor.getThvTemperature();
        Long goafDataId = goafSensorData.getGoafDataId();
        Long accX = goafSensorData.getAccX();
        Long accY = goafSensorData.getAccY();
        Long accZ = goafSensorData.getAccZ();
        Long velX = goafSensorData.getVelX();
        Long velY = goafSensorData.getVelY();
        Long velZ = goafSensorData.getVelZ();
        Long disX = goafSensorData.getDisX();
        Long disY = goafSensorData.getDisY();
        Long disZ = goafSensorData.getDisZ();
        Long sensorTemperature = goafSensorData.getSensorTemperature();
        if (accX > thvAccX || accY > thvAccY || accZ > thvAccZ) {
            goafSensorAlarmLevel = Glob.SENSOR_ALARM_LEVEL_GENERAL;
            goafSensorAlarmType = "\u52a0\u901f\u5ea6|";
        }
        if (velX > thvVelX || velY > thvVelY || velZ > thvVelZ) {
            goafSensorAlarmLevel = Glob.SENSOR_ALARM_LEVEL_GENERAL;
            goafSensorAlarmType = goafSensorAlarmType + "\u901f\u5ea6|";
        }
        if (disX > thvDisX || disY > thvDisY || disZ > thvDisZ) {
            goafSensorAlarmLevel = Glob.SENSOR_ALARM_LEVEL_GENERAL;
            goafSensorAlarmType = goafSensorAlarmType + "\u4f4d\u79fb|";
        }
        if (sensorTemperature / 10L > thvTemperature) {
            goafSensorAlarmLevel = Glob.SENSOR_ALARM_LEVEL_GENERAL;
            goafSensorAlarmType = goafSensorAlarmType + "\u6e29\u5ea6";
        }
        if (goafSensorAlarmLevel < 0L) {
            return;
        }
        goafSensoralarm.setGoafDataId(goafDataId);
        goafSensoralarm.setGoafSensorAlarmLevel(goafSensorAlarmLevel);
        goafSensoralarm.setGoafSensorAlarmType(goafSensorAlarmType);
        try {
            Long goafSensorAlarmId = IdKit.getId();
            goafSensoralarm.setGoafSensorAlarmId(goafSensorAlarmId);
            GoafSensoralarmMapper goafSensoralarmMapper = (GoafSensoralarmMapper)ApplicationContextHelper.getBean(GoafSensoralarmMapper.class);
            goafSensoralarmMapper.create(goafSensoralarm);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
    }

    @Transactional
    public void SaveSensorData(GoafSensorData goafSensorData, String clientIP) {
        GoafSensorMapper goafSensorMapper = (GoafSensorMapper)ApplicationContextHelper.getBean(GoafSensorMapper.class);
        long sensorcodepart = iptosensorcodeMap.get(clientIP).intValue();
        long sensorcode = Glob.SENSOR_SCODE_BASE_NUM + sensorcodepart;
        System.out.println("SaveSensorData, clientIP:" + clientIP);
        System.out.println("SaveSensorData, sensorcode:" + sensorcode);
        GoafSensor goafSensor = goafSensorMapper.getByGoafsensorCode(sensorcode);
        if (null == goafSensor) {
            System.out.println("SaveSensorData, null == goafSensor");
            return;
        }
        Long ocId = goafSensor.getOcId();
        Long SensorId = goafSensor.getGoafSensorId();
        String goafSensorName = goafSensor.getGoafSensorName();
        String goafDevName = goafSensor.getGoafDevName();
        String goafDevTypename = goafSensor.getGoafDevTypename();
        LocalDateTime tNow = LocalDateTime.now();
        goafSensorData.setOcId(ocId);
        goafSensorData.setGoafSensorId(SensorId);
        goafSensorData.setGoafSensorName(goafSensorName);
        goafSensorData.setGoafDevName(goafDevName);
        goafSensorData.setGoafDevTypename(goafDevTypename);
        goafSensorData.setGoafDatareportTime(tNow);
        try {
            Long goafDataId = IdKit.getId();
            goafSensorData.setGoafDataId(goafDataId);
            GoafSensorDataMapper goafSensorDataMapper = (GoafSensorDataMapper)ApplicationContextHelper.getBean(GoafSensorDataMapper.class);
            goafSensorDataMapper.create(goafSensorData);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("goafSensorId", SensorId);
            GoafSensorData goafSensorDataLatest = goafSensorDataMapper.getLatestDatabySensorId(map);
            if (null == goafSensorDataLatest) {
                goafSensorDataMapper.createLatestData(goafSensorData);
            } else {
                goafSensorDataMapper.updateLatestData(goafSensorData);
            }
            goafSensor.setGoafSensorStatus(0L);
            goafSensorMapper.update(goafSensor);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException();
        }
        this.SaveSensorAlarm(goafSensorData);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("ocId", ocId);
        String strtopic = "topic/iotplatform/update/all/" + ocId;
        MqttUtil mqttUtil = (MqttUtil)ApplicationContextHelper.getBean(MqttUtil.class);
        mqttUtil.publish(strtopic, map);
    }

    public void getModbusId(String clientIP) {
        ChannelHandlerContext ctx = channleMap.get(clientIP);
        byte[] bytes = new byte[]{1, 4, 0, 2, 0, 4};
        stateMap.put(clientIP, Glob.SENSOR_STATE_GET_SENSORCODE);
        this.sendmsgtosensor(ctx, bytes);
    }

    public void cfgSensor(String clientIP) {
        GoafSensorMapper goafSensorMapper = (GoafSensorMapper)ApplicationContextHelper.getBean(GoafSensorMapper.class);
        GoafSensor goafSensor = goafSensorMapper.getByGoafSensorIP(clientIP);
        int thvAccX = goafSensor.getThvAccX().intValue();
        int thvAccY = goafSensor.getThvAccY().intValue();
        int thvAccZ = goafSensor.getThvAccZ().intValue();
        int thvVelX = goafSensor.getThvVelX().intValue();
        int thvVelY = goafSensor.getThvVelY().intValue();
        int thvVelZ = goafSensor.getThvVelZ().intValue();
        int thvDisX = goafSensor.getThvDisX().intValue();
        int thvDisY = goafSensor.getThvDisY().intValue();
        int thvDisZ = goafSensor.getThvDisZ().intValue();
        int thvTemperature = goafSensor.getThvTemperature().intValue();
        byte[] bytes = new byte[]{1, 16, 0, 99, 0, 10, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] tempbyte = this.IntToBytes(thvAccX);
        bytes[7] = tempbyte[2];
        bytes[8] = tempbyte[3];
        tempbyte = this.IntToBytes(thvAccY);
        bytes[9] = tempbyte[2];
        bytes[10] = tempbyte[3];
        tempbyte = this.IntToBytes(thvAccZ);
        bytes[11] = tempbyte[2];
        bytes[12] = tempbyte[3];
        tempbyte = this.IntToBytes(thvVelX);
        bytes[13] = tempbyte[2];
        bytes[14] = tempbyte[3];
        tempbyte = this.IntToBytes(thvVelY);
        bytes[15] = tempbyte[2];
        bytes[16] = tempbyte[3];
        tempbyte = this.IntToBytes(thvVelZ);
        bytes[17] = tempbyte[2];
        bytes[18] = tempbyte[3];
        tempbyte = this.IntToBytes(thvDisX);
        bytes[19] = tempbyte[2];
        bytes[20] = tempbyte[3];
        tempbyte = this.IntToBytes(thvDisY);
        bytes[21] = tempbyte[2];
        bytes[22] = tempbyte[3];
        tempbyte = this.IntToBytes(thvDisZ);
        bytes[23] = tempbyte[2];
        bytes[24] = tempbyte[3];
        tempbyte = this.IntToBytes(thvTemperature);
        bytes[25] = tempbyte[2];
        bytes[26] = tempbyte[3];
        stateMap.put(clientIP, Glob.SENSOR_STATE_CFG);
        ChannelHandlerContext ctx = channleMap.get(clientIP);
        this.sendmsgtosensor(ctx, bytes);
    }
}

