/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.goaf.nettyservicehandle;

import com.zhyc.xps.common.spring.ApplicationContextHelper;
import com.zhyc.xps.common.utils.ModbusCRC16;
import com.zhyc.xps.goaf.job.GoafCheckTaskJobService;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.time.LocalDateTime;

public class NettyServerHandler
extends ChannelInboundHandlerAdapter {
    private static int icount = 0;

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        int address = System.identityHashCode(ctx);
        System.out.println("ctx Address: " + Integer.toHexString(address));
        System.out.println("handlerAdded /r/n ");
        System.out.println("\u5ba2\u6237\u7aef\u88abAdded\uff0cchannelId\u4e3a\uff1a" + ctx.channel().id().asShortText());
        InetSocketAddress insocket = (InetSocketAddress)ctx.channel().remoteAddress();
        String clientIP = insocket.getAddress().getHostAddress();
        String clientPort = String.valueOf(insocket.getPort());
        System.out.println("handlerAdded\u65b0\u7684\u8fde\u63a5\uff1a" + clientIP + ":" + clientPort);
        LocalDateTime tNow = LocalDateTime.now();
        System.out.println("time: " + tNow.toString());
    }

    public void channelRegistered(ChannelHandlerContext ctx) {
        int address = System.identityHashCode(ctx);
        System.out.println("ctx Address: " + Integer.toHexString(address));
        System.out.println("channelRegistered /r/n ");
        InetSocketAddress insocket = (InetSocketAddress)ctx.channel().remoteAddress();
        String clientIP = insocket.getAddress().getHostAddress();
        String clientPort = String.valueOf(insocket.getPort());
        System.out.println("channelRegistered\u65b0\u7684\u8fde\u63a5\uff1a" + clientIP + ":" + clientPort);
    }

    public String byteToHexString(byte mByte) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] arr = new char[]{Digit[mByte >>> 4 & 0xF], Digit[mByte & 0xF]};
        String tmp = new String(arr);
        return tmp;
    }

    public void sendmsgtosensor(ChannelHandlerContext ctx, byte[] cmdbytes) {
        int i;
        int ilenth = cmdbytes.length;
        byte[] byteswithcrc = new byte[ilenth + 2];
        String crc16 = ModbusCRC16.getStringCRC((byte[])cmdbytes);
        byte[] crc = ModbusCRC16.getByteCRC((byte[])cmdbytes);
        System.out.println("crc16:  " + crc16);
        for (i = 0; i < cmdbytes.length; ++i) {
            byteswithcrc[i] = cmdbytes[i];
        }
        byteswithcrc[ilenth] = crc[0];
        byteswithcrc[ilenth + 1] = crc[1];
        System.out.println("send cmd start  ");
        for (i = 0; i < byteswithcrc.length; ++i) {
            String temp1 = this.byteToHexString(byteswithcrc[i]);
            System.out.print("  " + temp1);
            System.out.println("");
        }
        System.out.println("send cmd end  ");
        ByteBuf resp = Unpooled.copiedBuffer((byte[])byteswithcrc);
        ctx.write((Object)resp);
        ctx.flush();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        int address = System.identityHashCode(ctx);
        System.out.println("ctx Address: " + Integer.toHexString(address));
        System.out.println("channelActive /r/n ");
        InetSocketAddress insocket = (InetSocketAddress)ctx.channel().remoteAddress();
        String clientIP = insocket.getAddress().getHostAddress();
        String clientPort = String.valueOf(insocket.getPort());
        System.out.println("channelActive\u65b0\u7684\u8fde\u63a5\uff1a" + clientIP + ":" + clientPort);
        String clientipport = clientIP + ":" + clientPort;
        GoafCheckTaskJobService.channleMap.put(clientipport, ctx);
        System.out.println("clientipport:" + clientipport);
        GoafCheckTaskJobService goafCheckTaskJobService = (GoafCheckTaskJobService)((Object)ApplicationContextHelper.getBean(GoafCheckTaskJobService.class));
        goafCheckTaskJobService.getModbusId(clientipport);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        int address = System.identityHashCode(ctx);
        System.out.println("ctx Address: " + Integer.toHexString(address));
        System.out.println("channelRead /r/n ");
        InetSocketAddress insocket = (InetSocketAddress)ctx.channel().remoteAddress();
        String clientIP = insocket.getAddress().getHostAddress();
        String clientPort = String.valueOf(insocket.getPort());
        System.out.println("channelRead\u8fde\u63a5\u4fe1\u606f\uff1a" + clientIP + ":" + clientPort);
        ByteBuf buf = (ByteBuf)msg;
        System.out.println("ByteBuf max Capacity : " + buf.maxCapacity());
        byte[] req = new byte[buf.readableBytes()];
        buf.readBytes(req);
        String clientIPPort = clientIP + ":" + clientPort;
        GoafCheckTaskJobService goafCheckTaskJobService = (GoafCheckTaskJobService)((Object)ApplicationContextHelper.getBean(GoafCheckTaskJobService.class));
        goafCheckTaskJobService.revmsg(clientIPPort, req);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        int address = System.identityHashCode(ctx);
        System.out.println("ctx Address: " + Integer.toHexString(address));
        System.out.println("channelReadComplete /r/n ");
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        System.out.println("exceptionCaught /r/n ");
        ctx.close();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception, IOException {
        System.out.println("channelInactive /r/n ");
        super.channelInactive(ctx);
        InetSocketAddress insocket = (InetSocketAddress)ctx.channel().remoteAddress();
        String clientIp = insocket.getAddress().getHostAddress();
        String clientPort = String.valueOf(insocket.getPort());
        ctx.close();
        System.out.println("\u8fde\u63a5\u65ad\u5f00\uff1a" + clientIp + ":" + clientPort);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) {
        System.out.println("channelUnregistered /r/n ");
        InetSocketAddress insocket = (InetSocketAddress)ctx.channel().remoteAddress();
        String clientIP = insocket.getAddress().getHostAddress();
        String clientPort = String.valueOf(insocket.getPort());
        System.out.println("\u8fde\u63a5\uff1a" + clientIP + ":" + clientPort);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        System.out.println("handlerRemoved /r/n ");
        String channelId = ctx.channel().id().asShortText();
        System.out.println("\u5ba2\u6237\u7aef\u88ab\u79fb\u9664\uff0cchannelId\u4e3a\uff1a" + channelId);
        InetSocketAddress insocket = (InetSocketAddress)ctx.channel().remoteAddress();
        String clientIP = insocket.getAddress().getHostAddress();
        String clientPort = String.valueOf(insocket.getPort());
        System.out.println("\u8fde\u63a5\uff1a" + clientIP + ":" + clientPort);
        String clientIPPort = clientIP + ":" + clientPort;
        GoafCheckTaskJobService.channleMap.remove(clientIPPort);
        GoafCheckTaskJobService.iptosensorcodeMap.remove(clientIPPort);
    }
}

