/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.goaf.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import com.zhyc.xps.goaf.dto.GoafChecklistDto;
import com.zhyc.xps.goaf.entity.GoafChecklist;
import com.zhyc.xps.goaf.entity.GoafChecklistItem;
import com.zhyc.xps.goaf.mapper.GoafChecklistItemMapper;
import com.zhyc.xps.goaf.mapper.GoafChecklistMapper;
import com.zhyc.xps.goaf.service.GoafChecklistService;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class GoafChecklistServiceImpl
extends BaseService
implements GoafChecklistService {
    @Resource
    GoafChecklistItemMapper goafChecklistItemMapper;
    @Resource
    GoafChecklistMapper goafChecklistMapper;

    @Override
    public List<GoafChecklist> getChecklistByList(Map<String, Object> map) {
        List<GoafChecklist> goafChecklist = this.goafChecklistMapper.getChecklistByList(map);
        return goafChecklist;
    }

    @Override
    public PageBean<GoafChecklist> getChecklistByPage(Map<String, Object> map) {
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List<GoafChecklist> goafChecklist = this.goafChecklistMapper.getChecklistByPage(map);
        return new PageBean(goafChecklist);
    }

    @Override
    public List<GoafChecklistItem> getChecklistItemById(Long goafChecklistId) {
        List<GoafChecklistItem> goafChecklistItemlist = this.goafChecklistItemMapper.getChecklistItemById(goafChecklistId);
        return goafChecklistItemlist;
    }

    @Override
    public void create(GoafChecklistDto goafChecklistDto) throws Exception {
        Long ocId = goafChecklistDto.getOcId();
        Long goafChecklistId = IdKit.getId();
        Long goafChecklistItemId = IdKit.getId();
        GoafChecklist goafChecklist = new GoafChecklist();
        goafChecklist.setOcId(ocId);
        goafChecklist.setChecklistId(goafChecklistId);
        goafChecklist.setChecklistDesc(goafChecklistDto.getChecklistDesc());
        goafChecklist.setChecklistTitle(goafChecklistDto.getChecklistTitle());
        this.goafChecklistMapper.create(goafChecklist);
        GoafChecklistItem goafChecklistItem = new GoafChecklistItem();
        goafChecklistItem.setChecklistId(goafChecklistId);
        goafChecklistItem.setChecklistItemId(goafChecklistItemId);
        goafChecklistItem.setChecklistItemContent(goafChecklistDto.getChecklistItemContent());
        this.goafChecklistItemMapper.create(goafChecklistItem);
    }

    @Override
    public void update(GoafChecklistDto goafChecklistDto) throws Exception {
        Long ocId = goafChecklistDto.getOcId();
        GoafChecklist goafChecklist = new GoafChecklist();
        goafChecklist.setOcId(ocId);
        goafChecklist.setChecklistId(goafChecklistDto.getChecklistId());
        goafChecklist.setChecklistDesc(goafChecklistDto.getChecklistDesc());
        goafChecklist.setChecklistTitle(goafChecklistDto.getChecklistTitle());
        this.goafChecklistMapper.update(goafChecklist);
        GoafChecklistItem goafChecklistItem = new GoafChecklistItem();
        goafChecklistItem.setChecklistId(goafChecklistDto.getChecklistId());
        goafChecklistItem.setChecklistItemContent(goafChecklistDto.getChecklistItemContent());
        Long ItemId = goafChecklistDto.getChecklistItemId();
        if (null == ItemId || 0L == ItemId) {
            ItemId = IdKit.getId();
            goafChecklistItem.setChecklistItemId(ItemId);
            this.goafChecklistItemMapper.create(goafChecklistItem);
        } else {
            goafChecklistItem.setChecklistItemId(ItemId);
            try {
                this.goafChecklistItemMapper.update(goafChecklistItem);
            }
            catch (Exception e) {
                throw new CustomException(e.getMessage());
            }
        }
    }

    @Override
    public void delete(Long checklistItemId) throws Exception {
        this.goafChecklistItemMapper.delete(checklistItemId);
    }

    @Override
    public void deleteAll(Long checklistsId) throws Exception {
        this.goafChecklistItemMapper.deleteAll(checklistsId);
        this.goafChecklistMapper.delete(checklistsId);
    }
}

