/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.goaf.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import com.zhyc.xps.goaf.dto.GoafDevSensorDataDto;
import com.zhyc.xps.goaf.dto.GoafDevSensorOverviewDto;
import com.zhyc.xps.goaf.dto.GoafSensorDataDto;
import com.zhyc.xps.goaf.dto.GoafSensoralarmOverviewDto;
import com.zhyc.xps.goaf.entity.GoafDevInfo;
import com.zhyc.xps.goaf.entity.GoafSensor;
import com.zhyc.xps.goaf.mapper.GoafDevInfoMapper;
import com.zhyc.xps.goaf.mapper.GoafSensorDataMapper;
import com.zhyc.xps.goaf.mapper.GoafSensorMapper;
import com.zhyc.xps.goaf.service.GoafDevInfoService;
import com.zhyc.xps.goaf.vo.DevStatisVo;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestParam;

@Service
@Transactional
public class GoafDevInfoServiceImpl
extends BaseService
implements GoafDevInfoService {
    @Resource
    GoafDevInfoMapper goafDevInfoMapper;
    @Resource
    GoafSensorMapper goafSensorMapper;
    @Resource
    GoafSensorDataMapper goafSensorDataMapper;

    @Override
    public List<GoafDevInfo> getByList(Map<String, Object> map) {
        List<GoafDevInfo> goafDevInfoList = this.goafDevInfoMapper.getByList(map);
        return goafDevInfoList;
    }

    @Override
    public PageBean<GoafDevInfo> getByPage(Map<String, Object> map) {
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List<GoafDevInfo> goafDevInfoList = this.goafDevInfoMapper.getByPage(map);
        return new PageBean(goafDevInfoList);
    }

    @Override
    public List<GoafDevSensorOverviewDto> getGoafDevOverviewByList(@RequestParam Map<String, Object> map) {
        List<GoafDevInfo> goafDevInfoList = this.goafDevInfoMapper.getByList(map);
        int devNum = goafDevInfoList.size();
        GoafDevSensorOverviewDto[] goafDevSensorOverviewDto = new GoafDevSensorOverviewDto[devNum];
        for (int i = 0; i < devNum; ++i) {
            GoafDevInfo goafDevInfo = goafDevInfoList.get(i);
            goafDevSensorOverviewDto[i] = new GoafDevSensorOverviewDto();
            goafDevSensorOverviewDto[i].ocId = goafDevInfo.getOcId();
            goafDevSensorOverviewDto[i].goafDevName = goafDevInfo.getGoafDevName();
            goafDevSensorOverviewDto[i].goafDevTypename = goafDevInfo.getGoafDevTypename();
            goafDevSensorOverviewDto[i].goafInstallTime = goafDevInfo.getGoafInstallTime();
            map.put("goafDevName", goafDevInfo.getGoafDevName());
            List<GoafSensor> goafSensorList = this.goafSensorMapper.getByList(map);
            int sensonNum = goafSensorList.size();
            GoafSensoralarmOverviewDto[] goafSensoralarmOverviewDto = goafDevSensorOverviewDto[i].goafSensoralarmOverviewDto = new GoafSensoralarmOverviewDto[sensonNum];
            for (int j = 0; j < sensonNum; ++j) {
                GoafSensor goafSensor = goafSensorList.get(j);
                map.put("goafSensorId", goafSensor.getGoafSensorId());
                goafSensoralarmOverviewDto[j] = this.goafSensorMapper.getGoafDevOverview(map);
            }
        }
        ArrayList<GoafDevSensorOverviewDto> goafDevSensorOverviewDtoList = new ArrayList<GoafDevSensorOverviewDto>(devNum);
        for (GoafDevSensorOverviewDto item : goafDevSensorOverviewDto) {
            goafDevSensorOverviewDtoList.add(item);
        }
        return goafDevSensorOverviewDtoList;
    }

    @Override
    public PageBean<GoafDevSensorOverviewDto> getGoafDevOverviewByPage(@RequestParam Map<String, Object> map) {
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List<GoafDevInfo> goafDevInfoList = this.goafDevInfoMapper.getByPage(map);
        int devNum = goafDevInfoList.size();
        GoafDevSensorOverviewDto[] goafDevSensorOverviewDto = new GoafDevSensorOverviewDto[devNum];
        for (int i = 0; i < devNum; ++i) {
            GoafDevSensorOverviewDto[] goafDevInfo = goafDevInfoList.get(i);
            goafDevSensorOverviewDto[i] = new GoafDevSensorOverviewDto();
            goafDevSensorOverviewDto[i].ocId = goafDevInfo.getOcId();
            goafDevSensorOverviewDto[i].goafDevName = goafDevInfo.getGoafDevName();
            goafDevSensorOverviewDto[i].goafDevTypename = goafDevInfo.getGoafDevTypename();
            goafDevSensorOverviewDto[i].goafInstallTime = goafDevInfo.getGoafInstallTime();
            map.put("goafDevName", goafDevInfo.getGoafDevName());
            List<GoafSensor> goafSensorList = this.goafSensorMapper.getByList(map);
            int sensonNum = goafSensorList.size();
            GoafSensoralarmOverviewDto[] goafSensoralarmOverviewDto = goafDevSensorOverviewDto[i].goafSensoralarmOverviewDto = new GoafSensoralarmOverviewDto[sensonNum];
            for (int j = 0; j < sensonNum; ++j) {
                GoafSensor goafSensor = goafSensorList.get(j);
                map.put("goafSensorId", goafSensor.getGoafSensorId());
                goafSensoralarmOverviewDto[j] = this.goafSensorMapper.getGoafDevOverview(map);
            }
        }
        ArrayList<GoafDevSensorOverviewDto> goafDevSensorOverviewDtoList = new ArrayList<GoafDevSensorOverviewDto>(devNum);
        for (GoafDevSensorOverviewDto item : goafDevSensorOverviewDto) {
            goafDevSensorOverviewDtoList.add(item);
        }
        PageBean data = new PageBean(goafDevSensorOverviewDtoList);
        return data;
    }

    @Override
    public List<GoafDevSensorDataDto> getGoafDevSensorDataByList(Map<String, Object> map) {
        List<GoafDevInfo> goafDevInfoList = this.goafDevInfoMapper.getByList(map);
        int devNum = goafDevInfoList.size();
        GoafDevSensorDataDto[] goafDevSensorDataDto = new GoafDevSensorDataDto[devNum];
        for (int i = 0; i < devNum; ++i) {
            GoafDevInfo goafDevInfo = goafDevInfoList.get(i);
            goafDevSensorDataDto[i] = new GoafDevSensorDataDto();
            goafDevSensorDataDto[i].goafDevName = goafDevInfo.getGoafDevName();
            goafDevSensorDataDto[i].goafDevTypename = goafDevInfo.getGoafDevTypename();
            map.put("goafDevName", goafDevInfo.getGoafDevName());
            List<GoafSensor> goafSensorList = this.goafSensorMapper.getByList(map);
            int sensonNum = goafSensorList.size();
            GoafSensorDataDto[] goafSensorData = goafDevSensorDataDto[i].goafSensorData = new GoafSensorDataDto[sensonNum];
            for (int j = 0; j < sensonNum; ++j) {
                GoafSensor goafSensor = goafSensorList.get(j);
                map.put("goafSensorId", goafSensor.getGoafSensorId());
                GoafSensorDataDto goafSensorDataDtoTemp = this.goafSensorDataMapper.getByNewWihoutWave(map);
                if (null == goafSensorDataDtoTemp) {
                    goafSensorData[j].setGoafSensorName(goafSensor.getGoafSensorName());
                    continue;
                }
                goafSensorData[j] = goafSensorDataDtoTemp;
            }
        }
        ArrayList<GoafDevSensorDataDto> listGoafDevSensorDataDto = new ArrayList<GoafDevSensorDataDto>(devNum);
        for (GoafDevSensorDataDto item : goafDevSensorDataDto) {
            listGoafDevSensorDataDto.add(item);
        }
        return listGoafDevSensorDataDto;
    }

    @Override
    public PageBean<GoafDevSensorDataDto> getGoafDevSensorDataByPage(Map<String, Object> map) {
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List<GoafDevInfo> goafDevInfoList = this.goafDevInfoMapper.getByPage(map);
        int devNum = goafDevInfoList.size();
        GoafDevSensorDataDto[] goafDevSensorDataDto = new GoafDevSensorDataDto[devNum];
        for (int i = 0; i < devNum; ++i) {
            GoafDevSensorDataDto[] goafDevInfo = goafDevInfoList.get(i);
            goafDevSensorDataDto[i] = new GoafDevSensorDataDto();
            goafDevSensorDataDto[i].goafDevName = goafDevInfo.getGoafDevName();
            goafDevSensorDataDto[i].goafDevTypename = goafDevInfo.getGoafDevTypename();
            map.put("goafDevName", goafDevInfo.getGoafDevName());
            List<GoafSensor> goafSensorList = this.goafSensorMapper.getByList(map);
            int sensonNum = goafSensorList.size();
            GoafSensorDataDto[] goafSensorData = goafDevSensorDataDto[i].goafSensorData = new GoafSensorDataDto[sensonNum];
            for (int j = 0; j < sensonNum; ++j) {
                GoafSensor goafSensor = goafSensorList.get(j);
                map.put("goafSensorId", goafSensor.getGoafSensorId());
                GoafSensorDataDto goafSensorDataDtoTemp = this.goafSensorDataMapper.getByNewWihoutWave(map);
                if (null == goafSensorDataDtoTemp) {
                    goafSensorData[j] = new GoafSensorDataDto();
                    goafSensorData[j].setGoafSensorName(goafSensor.getGoafSensorName());
                    continue;
                }
                goafSensorData[j] = goafSensorDataDtoTemp;
            }
        }
        ArrayList<GoafDevSensorDataDto> listGoafDevSensorDataDto = new ArrayList<GoafDevSensorDataDto>(devNum);
        for (GoafDevSensorDataDto item : goafDevSensorDataDto) {
            listGoafDevSensorDataDto.add(item);
        }
        PageBean data = new PageBean(listGoafDevSensorDataDto);
        return data;
    }

    @Override
    public GoafDevInfo getByGoafDevId(Long goafDevId) {
        GoafDevInfo GoafDevInfo2 = this.goafDevInfoMapper.getByGoafDevId(goafDevId);
        return GoafDevInfo2;
    }

    @Override
    public GoafDevInfo getByGoafDevName(String goafDevName) {
        GoafDevInfo GoafDevInfo2 = this.goafDevInfoMapper.getByGoafDevName(goafDevName);
        return GoafDevInfo2;
    }

    @Override
    public DevStatisVo getStatisNum(Map<String, Object> map) {
        DevStatisVo devStatisVo = this.goafDevInfoMapper.getStatisNum(map);
        return devStatisVo;
    }

    @Override
    public void create(GoafDevInfo goafDevInfo) throws Exception {
        Long goafDevId = IdKit.getId();
        goafDevInfo.setGoafDevId(goafDevId);
        this.goafDevInfoMapper.create(goafDevInfo);
    }

    @Override
    public void update(GoafDevInfo goafDevInfo) throws Exception {
        this.goafDevInfoMapper.update(goafDevInfo);
    }

    @Override
    public void delete(Long goafDevId) throws Exception {
        this.goafDevInfoMapper.delete(goafDevId);
    }
}

