/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.goaf.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import com.zhyc.xps.goaf.dto.GoafMapDto;
import com.zhyc.xps.goaf.entity.GoafMapFlayer;
import com.zhyc.xps.goaf.mapper.GoafMapFlayerMapper;
import com.zhyc.xps.goaf.service.GoafMapFlayerService;
import com.zhyc.xps.sys.constant.Glob;
import com.zhyc.xps.sys.entity.EntMapLayer;
import com.zhyc.xps.sys.mapper.EntMapLayerMapper;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class GoafMapFlayerServiceImpl
extends BaseService
implements GoafMapFlayerService {
    @Resource
    EntMapLayerMapper mapLayerMapper;
    @Resource
    GoafMapFlayerMapper goafMapFlayerMapper;

    @Override
    public List<GoafMapDto> getByList(Map<String, Object> map) {
        List<GoafMapDto> goafMapDtoList = this.goafMapFlayerMapper.getByList(map);
        return goafMapDtoList;
    }

    @Override
    public PageBean<GoafMapDto> getByPage(Map<String, Object> map) {
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List<GoafMapDto> goafMapDtoList = this.goafMapFlayerMapper.getByPage(map);
        return new PageBean(goafMapDtoList);
    }

    @Override
    public GoafMapDto getById(Long goaflayerId) {
        GoafMapDto gGoafMapDto = this.goafMapFlayerMapper.getById(goaflayerId);
        return gGoafMapDto;
    }

    @Override
    public void create(GoafMapDto goafMapDto) throws Exception {
        Long ocId = goafMapDto.getOcId();
        Long mapId = goafMapDto.getMapId();
        Long goaflayerId = IdKit.getId();
        Long layerId = IdKit.getId();
        EntMapLayer mapLayer = new EntMapLayer();
        mapLayer.setLayerId(layerId);
        mapLayer.setOcId(ocId);
        mapLayer.setMapId(mapId);
        mapLayer.setLayerId(layerId);
        mapLayer.setLayerCatId(Glob.MAP_LAYER_CAT_RISKPOINT);
        mapLayer.setLayerTitle(goafMapDto.getLayerTitle());
        mapLayer.setLayerMarker(goafMapDto.getLayerMarker());
        mapLayer.setLayerVector(goafMapDto.getLayerVector());
        mapLayer.setLayerVectorType(goafMapDto.getLayerVectorType());
        this.mapLayerMapper.create(mapLayer);
        GoafMapFlayer goafMapFlayer = new GoafMapFlayer();
        goafMapFlayer.setGoaflayerId(goaflayerId);
        goafMapFlayer.setLayerId(layerId);
        goafMapFlayer.setMapId(mapId);
        goafMapFlayer.setGoafId(goafMapDto.getGoafId());
        goafMapFlayer.setGoafName(goafMapDto.getGoafName());
        goafMapFlayer.setOcId(goafMapDto.getOcId());
        this.goafMapFlayerMapper.create(goafMapFlayer);
    }

    @Override
    public void update(GoafMapDto goafMapDto) throws Exception {
        Long ocId = goafMapDto.getOcId();
        Long mapId = goafMapDto.getMapId();
        Long layerId = goafMapDto.getLayerId();
        EntMapLayer mapLayer = new EntMapLayer();
        mapLayer.setOcId(ocId);
        mapLayer.setMapId(mapId);
        mapLayer.setLayerId(layerId);
        mapLayer.setLayerTitle(goafMapDto.getLayerTitle());
        mapLayer.setLayerMarker(goafMapDto.getLayerMarker());
        mapLayer.setLayerVector(goafMapDto.getLayerVector());
        mapLayer.setLayerVectorType(goafMapDto.getLayerVectorType());
        this.mapLayerMapper.update(mapLayer);
        GoafMapFlayer goafMapFlayer = new GoafMapFlayer();
        goafMapFlayer.setGoaflayerId(goafMapDto.getGoaflayerId());
        goafMapFlayer.setLayerId(layerId);
        goafMapFlayer.setMapId(mapId);
        goafMapFlayer.setGoafId(goafMapDto.getGoafId());
        goafMapFlayer.setGoafName(goafMapDto.getGoafName());
        goafMapFlayer.setOcId(goafMapDto.getOcId());
        try {
            this.goafMapFlayerMapper.update(goafMapFlayer);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
    }

    @Override
    public void delete(Long ocId, Long goaflayerId, Long mapId, Long layerId) throws Exception {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("ocId", ocId);
        map.put("mapId", mapId);
        map.put("layerId", layerId);
        this.mapLayerMapper.delete(map);
        try {
            this.goafMapFlayerMapper.delete(goaflayerId);
        }
        catch (Exception e) {
            throw new CustomException(e.getMessage());
        }
    }
}

