/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.goaf.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import com.zhyc.xps.goaf.entity.GoafSensor;
import com.zhyc.xps.goaf.mapper.GoafSensorMapper;
import com.zhyc.xps.goaf.service.GoafSensorService;
import com.zhyc.xps.goaf.vo.DevStatisVo;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class GoafSensorServiceImpl
extends BaseService
implements GoafSensorService {
    @Resource
    GoafSensorMapper goafSensorMapper;

    @Override
    public List<GoafSensor> getByList(Map<String, Object> map) {
        List<GoafSensor> goafSensorList = this.goafSensorMapper.getByList(map);
        return goafSensorList;
    }

    @Override
    public PageBean<GoafSensor> getByPage(Map<String, Object> map) {
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List<GoafSensor> goafSensorList = this.goafSensorMapper.getByPage(map);
        return new PageBean(goafSensorList);
    }

    @Override
    public GoafSensor getByGoafSensorId(Long goafSensorId) {
        GoafSensor GoafSensor2 = this.goafSensorMapper.getByGoafSensorId(goafSensorId);
        return GoafSensor2;
    }

    @Override
    public GoafSensor getByGoafSensorName(Map<String, Object> map) {
        GoafSensor GoafSensor2 = this.goafSensorMapper.getByGoafSensorName(map);
        return GoafSensor2;
    }

    @Override
    public DevStatisVo getStatisNum(Map<String, Object> map) {
        DevStatisVo devStatisVo = this.goafSensorMapper.getStatisNum(map);
        return devStatisVo;
    }

    @Override
    public void create(GoafSensor goafSensor) throws Exception {
        Long goafSensorId = IdKit.getId();
        goafSensor.setGoafSensorId(goafSensorId);
        String goafSensorName = goafSensor.getGoafSensorName();
        if (null == goafSensorName || "" == goafSensorName) {
            return;
        }
        Long sensorCode = Long.parseLong(goafSensorName);
        goafSensor.setSensorCode(sensorCode);
        this.goafSensorMapper.create(goafSensor);
    }

    @Override
    public void update(GoafSensor goafSensor) throws Exception {
        String goafSensorName = goafSensor.getGoafSensorName();
        if (null != goafSensorName && "" != goafSensorName) {
            Long sensorCode = Long.parseLong(goafSensorName);
            goafSensor.setSensorCode(sensorCode);
        }
        this.goafSensorMapper.update(goafSensor);
    }

    @Override
    public void delete(Long goafDevId) throws Exception {
        this.goafSensorMapper.delete(goafDevId);
    }
}

