/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.goaf.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.github.pagehelper.PageHelper;
import com.zhyc.xps.bpm.service.WfService;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import com.zhyc.xps.goaf.dto.GoafSensoralarmDto;
import com.zhyc.xps.goaf.entity.GoafSensoralarm;
import com.zhyc.xps.goaf.mapper.GoafSensoralarmMapper;
import com.zhyc.xps.goaf.service.GoafHdangerService;
import com.zhyc.xps.goaf.service.GoafSensoralarmService;
import com.zhyc.xps.goaf.vo.SensorAlarmNumVo;
import com.zhyc.xps.goaf.vo.SensorAlarmStatisVo;
import jakarta.annotation.Resource;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class GoafSensoralarmServiceImpl
extends BaseService
implements GoafSensoralarmService {
    @Resource
    GoafSensoralarmMapper goafSensoralarmMapper;
    @Resource
    WfService wfService;
    @Resource
    GoafHdangerService goafHdangerService;

    @Override
    public List<GoafSensoralarmDto> getByList(Map<String, Object> map) {
        List<GoafSensoralarmDto> goafSensoralarmList = this.goafSensoralarmMapper.getByList(map);
        return goafSensoralarmList;
    }

    @Override
    public List<GoafSensoralarmDto> getBigScreenSensoralarmByList(Map<String, Object> map) {
        LocalDateTime endDate = LocalDateTime.now();
        DateTime offTime = DateUtil.offsetMinute((Date)DateTime.now(), (int)-1000);
        LocalDateTime startDate = DateUtil.toLocalDateTime((Date)offTime);
        map.put("startDate", startDate);
        map.put("endDate", endDate);
        List<GoafSensoralarmDto> goafSensoralarmList = this.goafSensoralarmMapper.getByList(map);
        return goafSensoralarmList;
    }

    @Override
    public PageBean<GoafSensoralarmDto> getByPage(Map<String, Object> map) {
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List<GoafSensoralarmDto> goafSensoralarmList = this.goafSensoralarmMapper.getByPage(map);
        return new PageBean(goafSensoralarmList);
    }

    @Override
    public SensorAlarmStatisVo getSensorAlarmStatis(Map<String, Object> map) {
        SensorAlarmStatisVo sensorAlarmStatisVo = new SensorAlarmStatisVo();
        LocalDate today = LocalDate.now();
        for (int i = 1; i <= 30; ++i) {
            LocalDate previousDate = today.minus(Period.ofDays(1));
            map.put("startDate", previousDate.toString());
            map.put("endDate", today.toString());
            Long sensorNormalNum = this.goafSensoralarmMapper.getsensorNormalNum(map);
            SensorAlarmNumVo sensorAlarmNumVo = this.goafSensoralarmMapper.getSensorAlarmNum(map);
            if (sensorAlarmNumVo == null || sensorAlarmNumVo.getSensorCriAlarmNum() == null || sensorAlarmNumVo.getSensorGenAlarmNum() == null) {
                today = previousDate;
                sensorAlarmStatisVo.sensorNormalNum[i - 1] = sensorNormalNum;
                continue;
            }
            sensorAlarmStatisVo.sensorGenAlarmNum[i - 1] = sensorAlarmNumVo.getSensorGenAlarmNum();
            sensorAlarmStatisVo.sensorCriAlarmNum[i - 1] = sensorAlarmNumVo.getSensorCriAlarmNum();
            sensorAlarmStatisVo.sensorNormalNum[i - 1] = sensorNormalNum - sensorAlarmStatisVo.sensorGenAlarmNum[i - 1] - sensorAlarmStatisVo.sensorCriAlarmNum[i - 1];
            today = previousDate;
        }
        return sensorAlarmStatisVo;
    }

    @Override
    public void create(GoafSensoralarm goafSensoralarm) throws Exception {
        Long goafSensoralarmId = IdKit.getId();
        goafSensoralarm.setGoafDataId(goafSensoralarmId);
        this.goafSensoralarmMapper.create(goafSensoralarm);
    }
}

