/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.goaf.service.impl;

import com.github.pagehelper.PageHelper;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.service.BaseService;
import com.zhyc.xps.common.utils.IdGenerator.IdKit;
import com.zhyc.xps.goaf.entity.GoafCheckRecord;
import com.zhyc.xps.goaf.entity.GoafTask;
import com.zhyc.xps.goaf.mapper.GoafTaskMapper;
import com.zhyc.xps.goaf.service.GoafCheckRecordService;
import com.zhyc.xps.goaf.service.GoafTaskService;
import jakarta.annotation.Resource;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class GoafTaskServiceImpl
extends BaseService
implements GoafTaskService {
    @Resource
    GoafTaskMapper goafTaskMapper;
    @Resource
    GoafCheckRecordService goafCheckRecordService;

    @Override
    public List<GoafTask> getByList(Map<String, Object> map) {
        List<GoafTask> goafTaskList = this.goafTaskMapper.getByList(map);
        return goafTaskList;
    }

    @Override
    public PageBean<GoafTask> getByPage(Map<String, Object> map) {
        int page = Integer.parseInt("0" + map.get("page"));
        int limit = Integer.parseInt("0" + map.get("limit"));
        PageHelper.startPage((int)page, (int)limit);
        List<GoafTask> goafTaskList = this.goafTaskMapper.getByPage(map);
        return new PageBean(goafTaskList);
    }

    @Override
    public GoafTask getBytaskId(Long taskId) {
        GoafTask GoafTask2 = this.goafTaskMapper.getBytaskId(taskId);
        return GoafTask2;
    }

    @Override
    public void completed(GoafTask goafTask) throws Exception {
        GoafCheckRecord goafCheckRecord = new GoafCheckRecord();
        Long taskId = goafTask.getTaskId();
        Long ocId = goafTask.getOcId();
        Long goafId = goafTask.getGoafId();
        Long jobId = goafTask.getJobId();
        Long checkDefId = goafTask.getCheckDefId();
        Long checklistId = goafTask.getChecklistId();
        String taskTitle = goafTask.getTaskTitle();
        String taskDesc = goafTask.getTaskDesc();
        LocalDate expectedStartDate = goafTask.getExpectedStartDate();
        LocalDate expectedEndDate = goafTask.getExpectedEndDate();
        LocalDateTime checkTime = LocalDateTime.now();
        Long handleAccountId = goafTask.getHandleAccountId();
        String handleAccountName = goafTask.getHandleAccountName();
        Long handlePositionId = goafTask.getHandlePositionId();
        String handlePositionName = goafTask.getHandlePositionName();
        Long handleGroupId = goafTask.getHandleGroupId();
        String handleGroupName = goafTask.getHandleGroupName();
        Long status = 1L;
        Long checkResult = goafTask.getCheckResult();
        String checkItemPass = goafTask.getCheckItemPass();
        String checkItemNopass = goafTask.getCheckItemNopass();
        goafCheckRecord.setOcId(ocId);
        goafCheckRecord.setGoafId(goafId);
        goafCheckRecord.setJobId(jobId);
        goafCheckRecord.setCheckDefId(checkDefId);
        goafCheckRecord.setChecklistId(checklistId);
        goafCheckRecord.setTaskTitle(taskTitle);
        goafCheckRecord.setTaskDesc(taskDesc);
        goafCheckRecord.setExpectedStartDate(expectedStartDate);
        goafCheckRecord.setExpectedEndDate(expectedEndDate);
        goafCheckRecord.setCheckTime(checkTime);
        goafCheckRecord.setHandleAccountId(handleAccountId);
        goafCheckRecord.setHandleAccountName(handleAccountName);
        goafCheckRecord.setHandlePositionId(handlePositionId);
        goafCheckRecord.setHandlePositionName(handlePositionName);
        goafCheckRecord.setHandleGroupId(handleGroupId);
        goafCheckRecord.setHandleGroupName(handleGroupName);
        goafCheckRecord.setStatus(status);
        goafCheckRecord.setCheckResult(checkResult);
        goafCheckRecord.setCheckItemPass(checkItemPass);
        goafCheckRecord.setCheckItemNopass(checkItemNopass);
        this.goafCheckRecordService.create(goafCheckRecord);
        this.goafTaskMapper.delete(taskId);
    }

    @Override
    public void create(GoafTask goafTask) throws Exception {
        Long taskId = IdKit.getId();
        goafTask.setTaskId(taskId);
        this.goafTaskMapper.create(goafTask);
    }

    @Override
    public void updatebyjobid(GoafTask goafTask) throws Exception {
        this.goafTaskMapper.updatebyjobid(goafTask);
    }

    @Override
    public void delete(Long taskId) throws Exception {
        this.goafTaskMapper.delete(taskId);
    }
}

