/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.zhyc.xps.aqpt.dto.AlertDto;
import com.zhyc.xps.aqpt.service.AlertService;
import com.zhyc.xps.aqpt.vo.AlertVo;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.common.vo.TaskUserVo;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/alert"})
public class AlertController
extends BaseController {
    @Resource
    AlertService alertService;

    @GetMapping(value={""})
    public JsonResult getAlertByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<AlertDto> data = this.alertService.getAlertByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getAlertByPage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<AlertDto> data = this.alertService.getAlertByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={"/{alertId}"})
    public JsonResult getAlertById(@PathVariable Long alertId) {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        Long userGroupId = this.getCurUserGroupId();
        Long userPositionId = this.getCurUserPositionId();
        TaskUserVo user = new TaskUserVo();
        user.setOcId(ocId);
        user.setGroupId(userGroupId);
        user.setPositionId(userPositionId);
        user.setAccountId(userId);
        AlertDto data = this.alertService.getAlertById(ocId, alertId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PostMapping(value={"/handle"})
    public JsonResult handleAlert(@RequestBody Map<String, Object> map) throws CustomException {
        JSONObject json = new JSONObject(map);
        AlertVo alert = (AlertVo)((Object)json.to(AlertVo.class, new JSONReader.Feature[0]));
        Long ocId = this.getCurOcId();
        Long groupId = this.getCurUserGroupId();
        String groupName = this.getCurUserGroupName();
        Long positionId = this.getCurUserPositionId();
        String positionName = this.getCurUserPositionName();
        Long userId = this.getCurUserId();
        String userName = this.getCurUserName();
        TaskUserVo user = new TaskUserVo();
        user.setOcId(ocId);
        user.setGroupId(groupId);
        user.setGroupName(groupName);
        user.setPositionId(positionId);
        user.setPositionName(positionName);
        user.setAccountId(userId);
        user.setAccountName(userName);
        try {
            this.alertService.handleAlert(user, alert);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @DeleteMapping(value={"/{alertId}"})
    public JsonResult deleteAlertById(@PathVariable Long alertId) throws CustomException {
        Long ocId = this.getCurOcId();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("ocId", ocId);
            map.put("alertId", alertId);
            this.alertService.deleteAlert(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

