/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.zhyc.xps.aqpt.service.AlertStatisService;
import com.zhyc.xps.aqpt.vo.AlertByMonthVo;
import com.zhyc.xps.aqpt.vo.AlertByStatusVo;
import com.zhyc.xps.aqpt.vo.AlertCounterVo;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.sys.dto.GroupDto;
import com.zhyc.xps.sys.service.GroupService;
import jakarta.annotation.Resource;
import java.util.Map;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/alert/statis"})
public class AlertStatisController
extends BaseController {
    @Resource
    AlertStatisService statisService;
    @Resource
    GroupService groupService;

    @GetMapping(value={"/getCounter"})
    public JsonResult getAlertCounter(@RequestParam Map<String, Object> map) {
        Long groupId;
        Long ocId = this.getCurOcId();
        GroupDto group = this.groupService.getGroupById(ocId, groupId = this.getCurUserGroupId());
        if (ObjectUtils.isEmpty((Object)group)) {
            this.resultErr("\u7528\u6237\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        Long groupLeft = group.getNodeLeft();
        Long groupRight = group.getNodeRight();
        map.put("ocId", ocId);
        map.put("groupLeft", groupLeft);
        map.put("groupRight", groupRight);
        AlertCounterVo counter = this.statisService.getCounter(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", counter);
    }

    @GetMapping(value={"/counterByStatus"})
    public JsonResult counterByStatus(@RequestParam Map<String, Object> map) {
        Long groupId;
        Long ocId = this.getCurOcId();
        GroupDto group = this.groupService.getGroupById(ocId, groupId = this.getCurUserGroupId());
        if (ObjectUtils.isEmpty((Object)group)) {
            this.resultErr("\u7528\u6237\u4fe1\u606f\u4e0d\u5b8c\u6574\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        Long groupLeft = group.getNodeLeft();
        Long groupRight = group.getNodeRight();
        map.put("ocId", ocId);
        map.put("groupLeft", groupLeft);
        map.put("groupRight", groupRight);
        AlertByStatusVo vo = this.statisService.counterByStatus(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", vo);
    }

    @GetMapping(value={"/counterByMonth"})
    public JsonResult counterByMonth(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        AlertByMonthVo vo = this.statisService.counterByMonth(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", vo);
    }
}

