/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.zhyc.xps.aqpt.dto.CheckDefDto;
import com.zhyc.xps.aqpt.entity.CheckDef;
import com.zhyc.xps.aqpt.service.CheckDefService;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/check/def"})
public class CheckDefController
extends BaseController {
    @Resource
    CheckDefService checkDefService;

    @GetMapping(value={""})
    public JsonResult getCheckDefByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<CheckDefDto> data = this.checkDefService.getCheckDefByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getCheckDefByPage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<CheckDefDto> data = this.checkDefService.getCheckDefByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={"/{riskPointId}/{checkDefId}"})
    public JsonResult getCheckDef(@PathVariable Long riskPointId, @PathVariable Long checkDefId) {
        Long ocId = this.getCurOcId();
        CheckDefDto data = this.checkDefService.getCheckDefById(ocId, riskPointId, checkDefId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PostMapping(value={"/add"})
    public JsonResult createCheckDef(@RequestBody CheckDef checkDef) throws CustomException {
        Long ocId = this.getCurOcId();
        try {
            checkDef.setOcId(ocId);
            checkDef.setCreatedBy(this.getCurUserId());
            this.checkDefService.createCheckDef(checkDef);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateCheckDef(@RequestBody CheckDef checkDef) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            checkDef.setOcId(ocId);
            checkDef.setUpdatedBy(userId);
            this.checkDefService.updateCheckDef(checkDef);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @PutMapping(value={"/updateStatus/{riskPointId}/{checkDefId}/{status}"})
    public JsonResult updateCheckDefStatus(@PathVariable Long riskPointId, @PathVariable Long checkDefId, @PathVariable Long status) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            CheckDef checkDef = new CheckDef();
            checkDef.setOcId(ocId);
            checkDef.setRiskPointId(riskPointId);
            checkDef.setCheckDefId(checkDefId);
            checkDef.setStatus(status);
            checkDef.setUpdatedBy(userId);
            this.checkDefService.updateCheckDef(checkDef);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{riskPointId}/{checkDefId}"})
    public JsonResult deleteCheckDefById(@PathVariable Long riskPointId, @PathVariable Long checkDefId) throws CustomException {
        Long ocId = this.getCurOcId();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("ocId", ocId);
            map.put("riskPointId", riskPointId);
            map.put("checkDefId", checkDefId);
            this.checkDefService.deleteCheckDef(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

