/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import cn.hutool.core.date.DateUtil;
import com.zhyc.xps.aqpt.service.CheckRecordStatisService;
import com.zhyc.xps.aqpt.vo.CheckRecordByChecklistVo;
import com.zhyc.xps.aqpt.vo.CheckRecordByMonthVo;
import com.zhyc.xps.aqpt.vo.CheckRecordByStatusVo;
import com.zhyc.xps.aqpt.vo.CheckRecordCounterVo;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.utils.DateUtils;
import com.zhyc.xps.sys.dto.GroupDto;
import com.zhyc.xps.sys.service.GroupService;
import jakarta.annotation.Resource;
import java.util.Date;
import java.util.HashMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/check/record/statis"})
public class CheckRecordStatisController
extends BaseController {
    @Resource
    CheckRecordStatisService statisService;
    @Resource
    GroupService groupService;

    @GetMapping(value={"/getCounter"})
    public JsonResult getCheckRecordCounter() {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        Long groupId = this.getCurUserGroupId();
        GroupDto group = this.groupService.getGroupById(ocId, groupId);
        Long groupLeft = group.getNodeLeft();
        Long groupRight = group.getNodeRight();
        CheckRecordCounterVo counter = new CheckRecordCounterVo();
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        map1.put("ocId", ocId);
        map1.put("nodeLeft", groupLeft);
        map1.put("nodeRight", groupRight);
        CheckRecordByStatusVo groupVo1 = this.statisService.counterByStatus(map1);
        int groupFailed = groupVo1.getFailed();
        int groupPassed = groupVo1.getPassed();
        counter.setGroupFailed(groupFailed);
        counter.setGroupPassed(groupPassed);
        counter.setGroupTotal(groupFailed + groupPassed);
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("ocId", ocId);
        map2.put("accountId", userId);
        CheckRecordByStatusVo userVo1 = this.statisService.counterByStatus(map2);
        int myFailed = userVo1.getFailed();
        int myPassed = userVo1.getPassed();
        counter.setMyFailed(myFailed);
        counter.setMyPassed(myPassed);
        counter.setMyTotal(myFailed + myPassed);
        HashMap<String, Object> map3 = new HashMap<String, Object>();
        map3.put("ocId", ocId);
        map3.put("accountId", userId);
        map3.put("day", DateUtils.getDate());
        int iMyToday = this.statisService.counterByCondition(map3);
        counter.setMyToday(iMyToday);
        HashMap<String, Object> map4 = new HashMap<String, Object>();
        map4.put("ocId", ocId);
        map4.put("nodeLeft", groupLeft);
        map4.put("nodeRight", groupRight);
        map4.put("day", DateUtils.getDate());
        int iGroupToday = this.statisService.counterByCondition(map4);
        counter.setGroupToday(iGroupToday);
        HashMap<String, Object> map5 = new HashMap<String, Object>();
        map5.put("ocId", ocId);
        map5.put("accountId", userId);
        map5.put("startDate", DateUtil.beginOfWeek((Date)new Date()));
        map5.put("endDate", DateUtil.endOfWeek((Date)new Date()));
        int iMyThisWeek = this.statisService.counterByCondition(map5);
        counter.setMyThisWeek(iMyThisWeek);
        HashMap<String, Object> map6 = new HashMap<String, Object>();
        map6.put("ocId", ocId);
        map6.put("nodeLeft", groupLeft);
        map6.put("nodeRight", groupRight);
        map6.put("startDate", DateUtil.beginOfWeek((Date)new Date()));
        map6.put("endDate", DateUtil.endOfWeek((Date)new Date()));
        int iGroupThisWeek = this.statisService.counterByCondition(map6);
        counter.setGroupThisWeek(iGroupThisWeek);
        HashMap<String, Object> map7 = new HashMap<String, Object>();
        map7.put("ocId", ocId);
        map7.put("accountId", userId);
        map7.put("startDate", DateUtil.beginOfMonth((Date)new Date()));
        map7.put("endDate", DateUtil.endOfMonth((Date)new Date()));
        int iMyThisMonth = this.statisService.counterByCondition(map7);
        counter.setMyThisMonth(iMyThisMonth);
        HashMap<String, Object> map8 = new HashMap<String, Object>();
        map8.put("ocId", ocId);
        map8.put("nodeLeft", groupLeft);
        map8.put("nodeRight", groupRight);
        map8.put("startDate", DateUtil.beginOfMonth((Date)new Date()));
        map8.put("endDate", DateUtil.endOfMonth((Date)new Date()));
        int iGroupThisMonth = this.statisService.counterByCondition(map8);
        counter.setGroupThisMonth(iGroupThisMonth);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", counter);
    }

    @GetMapping(value={"/counterByChecklist"})
    public JsonResult getCounterByDangerCat() {
        Long ocId = this.getCurOcId();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocId", ocId);
        CheckRecordByChecklistVo vo = this.statisService.counterByChecklist(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", vo);
    }

    @GetMapping(value={"/counterByMonth/{year}"})
    public JsonResult getCounterByDangerMonth(@PathVariable String year) {
        Long ocId = this.getCurOcId();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ocId", ocId);
        map.put("year", year);
        CheckRecordByMonthVo vo = this.statisService.counterByMonth(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", vo);
    }
}

