/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.zhyc.xps.aqpt.dto.ChecklistHazardDto;
import com.zhyc.xps.aqpt.entity.ChecklistHazard;
import com.zhyc.xps.aqpt.service.ChecklistHazardService;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/checklist/hazard"})
public class ChecklistHazardController
extends BaseController {
    @Resource
    ChecklistHazardService hazardService;

    @GetMapping(value={"/page"})
    public PageResult getHazardByPage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<ChecklistHazardDto> data = this.hazardService.getHazardByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={""})
    public JsonResult getHazardByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<ChecklistHazardDto> data = this.hazardService.getHazardByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/{checklistId}/{hazardId}"})
    public JsonResult getHazardById(@PathVariable Long checklistId, @PathVariable Long hazardId) {
        Long ocId = this.getCurOcId();
        ChecklistHazardDto data = this.hazardService.getHazardById(ocId, checklistId, hazardId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PostMapping(value={"/add"})
    public JsonResult createHazard(@RequestBody ChecklistHazard hazard) throws CustomException {
        Long hazardId;
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            hazard.setOcId(ocId);
            hazard.setCreatedBy(userId);
            hazardId = this.hazardService.createHazard(hazard);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f", hazardId);
    }

    @PutMapping(value={"/update"})
    public JsonResult updateHazard(@RequestBody ChecklistHazard hazard) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            hazard.setOcId(ocId);
            hazard.setUpdatedBy(userId);
            this.hazardService.updateHazard(hazard);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{checklistId}/{hazardId}"})
    public JsonResult deleteHazardById(@PathVariable Long checklistId, @PathVariable Long hazardId) throws CustomException {
        Long ocId = this.getCurOcId();
        try {
            this.hazardService.deleteHazardById(ocId, checklistId, hazardId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

