/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.zhyc.xps.aqpt.dto.EntDangerDto;
import com.zhyc.xps.aqpt.service.EntDangerService;
import com.zhyc.xps.aqpt.vo.DangerVo;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import com.zhyc.xps.common.vo.TaskUserVo;
import jakarta.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ent/danger"})
public class EntDangerController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(EntDangerController.class);
    @Resource
    EntDangerService dangerService;

    @GetMapping(value={""})
    public JsonResult getDangerByList(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        List<EntDangerDto> data = this.dangerService.getDangerByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getDangerByPage(@RequestParam Map<String, Object> map) {
        Long ocId = this.getCurOcId();
        map.put("ocId", ocId);
        PageBean<EntDangerDto> data = this.dangerService.getDangerByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={"/{dangerId}"})
    public JsonResult getDangerById(@PathVariable Long dangerId) {
        Long ocId = this.getCurOcId();
        DangerVo data = this.dangerService.getDangerById(ocId, dangerId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PostMapping(value={"/handle"})
    public JsonResult handleDanger(@RequestBody Map<String, Object> map) throws CustomException {
        JSONObject json = new JSONObject(map);
        DangerVo danger = (DangerVo)json.to(DangerVo.class, new JSONReader.Feature[0]);
        Long ocId = this.getCurOcId();
        Long groupId = this.getCurUserGroupId();
        Long positionId = this.getCurUserPositionId();
        Long userId = this.getCurUserId();
        TaskUserVo user = new TaskUserVo();
        user.setOcId(ocId);
        user.setGroupId(groupId);
        user.setGroupName(this.getCurUserGroupName());
        user.setPositionId(positionId);
        user.setPositionName(this.getCurUserPositionName());
        user.setAccountId(userId);
        user.setAccountName(this.getCurUserName());
        try {
            this.dangerService.handleDanger(user, danger);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @DeleteMapping(value={"/{dangerId}"})
    public JsonResult deleteDangerById(@PathVariable Long dangerId) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("ocId", ocId);
            map.put("dangerId", dangerId);
            map.put("deletedBy", userId);
            this.dangerService.deleteDanger(map);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

