/*
 * Decompiled with CFR 0.152.
 */
package com.zhyc.xps.aqpt.controller;

import com.zhyc.xps.aqpt.dto.ChecklistHazardRiskDto;
import com.zhyc.xps.aqpt.entity.ChecklistHazardRisk;
import com.zhyc.xps.aqpt.service.ChecklistHazardRiskService;
import com.zhyc.xps.aqpt.vo.ChecklistHazardRiskVo;
import com.zhyc.xps.common.controller.BaseController;
import com.zhyc.xps.common.dto.JsonResult;
import com.zhyc.xps.common.dto.PageResult;
import com.zhyc.xps.common.entity.PageBean;
import com.zhyc.xps.common.exception.CustomException;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ent/hazard/risk"})
public class EntHazardRiskController
extends BaseController {
    @Resource
    ChecklistHazardRiskService riskService;

    @GetMapping(value={""})
    public JsonResult getRiskByList(@RequestParam Map<String, Object> map) {
        Long ocId;
        Long checklistId = ocId = this.getCurOcId();
        map.put("ocId", ocId);
        map.put("checklistId", checklistId);
        List<ChecklistHazardRiskVo> data = this.riskService.getRiskByList(map);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @GetMapping(value={"/page"})
    public PageResult getRiskByPage(@RequestParam Map<String, Object> map) {
        Long ocId;
        Long checklistId = ocId = this.getCurOcId();
        map.put("ocId", ocId);
        map.put("checklistId", checklistId);
        PageBean<ChecklistHazardRiskVo> data = this.riskService.getRiskByPage(map);
        return this.pageResult(data);
    }

    @GetMapping(value={"/{hazardId}/{riskId}"})
    public JsonResult getRiskById(@PathVariable Long hazardId, @PathVariable Long riskId) {
        Long ocId;
        Long checklistId = ocId = this.getCurOcId();
        ChecklistHazardRiskDto data = this.riskService.getRiskById(ocId, checklistId, hazardId, riskId);
        return this.resultOk("\u83b7\u53d6\u6210\u529f", data);
    }

    @PostMapping(value={"/add"})
    public JsonResult createRisk(@RequestBody ChecklistHazardRiskDto risk) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        Long checklistId = ocId;
        try {
            risk.setOcId(ocId);
            risk.setChecklistId(checklistId);
            risk.setChecklistId(ocId);
            risk.setCreatedBy(userId);
            this.riskService.createRisk(risk);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u4fdd\u5b58\u6210\u529f");
    }

    @PutMapping(value={"/update"})
    public JsonResult updateRisk(@RequestBody ChecklistHazardRiskDto risk) throws CustomException {
        Long ocId = this.getCurOcId();
        Long userId = this.getCurUserId();
        try {
            risk.setOcId(ocId);
            risk.setChecklistId(ocId);
            risk.setUpdatedBy(userId);
            this.riskService.updateRisk(risk);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @PostMapping(value={"/updateLevel"})
    public JsonResult updateRiskLevel(@RequestBody ChecklistHazardRisk risk) throws CustomException {
        Long ocId;
        Long checklistId = ocId = this.getCurOcId();
        try {
            Long hazardId = risk.getHazardId();
            Long riskId = risk.getRiskId();
            Long riskLevel = risk.getRiskLevel();
            this.riskService.updateRiskLevel(ocId, checklistId, hazardId, riskId, riskLevel);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{hazardId}/{riskId}"})
    public JsonResult deleteRisk(@PathVariable Long hazardId, @PathVariable Long riskId) throws CustomException {
        Long ocId;
        Long checklistId = ocId = this.getCurOcId();
        try {
            this.riskService.deleteRiskById(ocId, checklistId, hazardId, riskId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CustomException(e.getMessage());
        }
        return this.resultOk("\u5220\u9664\u6210\u529f");
    }
}

